-- 公共SQL：生成同步气价计划指令（适用SL1）
-- 必选参数
-- stairPriceSync：气价方案同步状态字段

SELECT
    -- 价格方案ID
    id                                         stairId,
    -- 价格方案名称
    f_stairtype                               price_name,
    -- 价格版本
    f_version                                  version,
    -- 阶梯周期（月）
    ISNULL(f_stairmonths, 1)                   f_stairmonths,
    -- 阶梯开始时间
    ISNULL(f_stair_start_date, f_perform_date) start_date,
    -- 价格截止时间
    f_end_date                                  end_date,
    -- 价格生效时间
    f_perform_date,
    -- 是否采暖气价
    f_isheat,
    -- 阶梯气价
    f_stair1price,
    f_stair2price,
    f_stair3price,
    -- 阶梯气量
    f_stair1amount,
    f_stair2amount,
    f_stair3amount
FROM t_stairprice s
WHERE s.${stairPriceSync} = '未同步'
