/*
 * Decompiled with CFR 0.152.
 */
package com.aote.webmeter.tools.iot;

import com.af.plugins.HttpConnectionPoolUtil;
import com.aote.webmeter.enums.IOTBusinessTypeEnum;
import com.aote.webmeter.enums.TelecomApiEnum;
import com.aote.webmeter.tools.WebMeterInfo;
import com.aote.webmeter.tools.iot.AuthenticationTools;
import java.io.IOException;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.log4j.Logger;
import org.json.JSONObject;

public class IotCommonTools {
    private static final Logger LOGGER = Logger.getLogger(IotCommonTools.class);
    private static final ThreadLocal<Boolean> IS_AEP = new ThreadLocal();
    public static final String ERROR_PARAMS_KEY = "error_code";

    public static JSONObject post(IOTBusinessTypeEnum typeEnum, HttpEntityEnclosingRequestBase base, JSONObject contentObj) throws IOException {
        return IotCommonTools.post(typeEnum, base, contentObj, null);
    }

    public static JSONObject post(IOTBusinessTypeEnum typeEnum, HttpEntityEnclosingRequestBase base, JSONObject contentObj, String urlAppend) throws IOException {
        String responseBody;
        String url;
        Boolean isAep = IS_AEP.get();
        if (isAep == null) {
            isAep = false;
        }
        String header = null;
        String content = null;
        if (typeEnum != IOTBusinessTypeEnum.AUTH && typeEnum != IOTBusinessTypeEnum.REFRESH_AUTH) {
            String accessToken = AuthenticationTools.getAuthToken();
            String appId = isAep != false ? WebMeterInfo.getString("aepAPIKey") : WebMeterInfo.getString("telecomAPIKey");
            JSONObject headerObj = new JSONObject();
            headerObj.put("app_key", (Object)appId);
            headerObj.put("Authorization", (Object)("Bearer " + accessToken));
            headerObj.put("Content-Type", (Object)"application/json");
            header = headerObj.toString();
        }
        if (contentObj != null) {
            content = contentObj.toString();
        }
        switch (typeEnum) {
            case AUTH: {
                if (!isAep.booleanValue()) {
                    url = TelecomApiEnum.AUTH_URL.getValue();
                    break;
                }
                url = TelecomApiEnum.AEP_AUTH_URL.getValue();
                break;
            }
            case REFRESH_AUTH: {
                if (!isAep.booleanValue()) {
                    url = TelecomApiEnum.REFRESH_AUTH_URL.getValue();
                    break;
                }
                url = TelecomApiEnum.AEP_REFRESH_AUTH_URL.getValue();
                break;
            }
            case CREATE_DEVICE: {
                if (!isAep.booleanValue()) {
                    url = TelecomApiEnum.DEVICE_CREATE_URL.getValue();
                    break;
                }
                url = TelecomApiEnum.AEP_DEVICE_CREATE_URL.getValue();
                break;
            }
            case MODIFY_DEVICE: 
            case REMOVE_DEVICE: {
                if (!isAep.booleanValue()) {
                    url = TelecomApiEnum.DEVICE_UPDATE_URL.getValue() + "/" + urlAppend;
                    break;
                }
                url = TelecomApiEnum.AEP_DEVICE_UPDATE_URL.getValue() + "/" + urlAppend;
                break;
            }
            case SEND_COMMAND: {
                if (!isAep.booleanValue()) {
                    url = TelecomApiEnum.SEND_INSTRUCT_URL.getValue();
                    break;
                }
                url = TelecomApiEnum.AEP_SEND_INSTRUCT_URL.getValue();
                break;
            }
            case SUBSCRIPTIONS: {
                if (!isAep.booleanValue()) {
                    url = TelecomApiEnum.SUBSCRIPTIONS_URL.getValue();
                    break;
                }
                url = TelecomApiEnum.AEP_SUBSCRIPTIONS_URL.getValue();
                break;
            }
            default: {
                throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u4e1a\u52a1\u7c7b\u578b\uff1a" + typeEnum.name());
            }
        }
        CloseableHttpClient client = isAep != false ? HttpConnectionPoolUtil.getHttpClient() : AuthenticationTools.getHttpClient();
        if (typeEnum == IOTBusinessTypeEnum.AUTH) {
            assert (contentObj != null);
            responseBody = HttpConnectionPoolUtil.requestFormUrlEncoded((String)url, (JSONObject)contentObj, (HttpEntityEnclosingRequestBase)base, (CloseableHttpClient)client);
        } else {
            LOGGER.debug((Object)("\u8bf7\u6c42\u7684\u5730\u5740\uff1a" + url));
            LOGGER.debug((Object)("\u8bf7\u6c42\u5934\uff1a" + header));
            LOGGER.debug((Object)("\u8bf7\u6c42\u4f53\uff1a" + content));
            responseBody = HttpConnectionPoolUtil.request((String)url, (String)content, (String)header, (HttpRequestBase)base, (CloseableHttpClient)client);
        }
        JSONObject result = responseBody != null ? new JSONObject(responseBody) : new JSONObject();
        LOGGER.debug((Object)("\u8c03\u7528\u5e73\u53f0API\u7ed3\u679c\uff1a" + result));
        return result;
    }

    public static void removeIsAep() {
        IS_AEP.remove();
    }

    public static void setIsAep(Boolean isAep) {
        IS_AEP.set(isAep);
    }

    public static Boolean getIsAep() {
        Boolean b = IS_AEP.get();
        if (b == null) {
            return false;
        }
        return b;
    }
}

