-- 公共SQL：生成调价指令（适用V3，用于先同步气价计划，再通过方案ID调价的情况）
-- 必选参数
-- f_meter_brand：表具品牌别名
-- stairPriceSync：气价方案同步状态字段
-- setPriceSync：调价记录同步状态字段

SELECT
    -- 业务记录ID
    setinfo.id,
    -- 表档案ID
    setinfo.userid,
    -- 表档案编号
    setinfo.f_user_id,
    -- 表号
    setinfo.f_meternumber,
    -- 卡号
    setinfo.f_card_id,
    -- 新气价ID
    setinfo.stairid,
    -- 旧气价ID
    setinfo.oldstairid,
    -- 气表型号
    setinfo.f_meter_style,
    -- 调价类型
    setinfo.type
FROM (
    SELECT p.id                                           id,
           u.f_userfiles_id                               userid,
           u.f_user_id,
           u.f_meternumber,
           NVL(u.f_card_id, u.f_meternumber)              f_card_id,
           s.id                                           stairId,
           p.f_oldprice_id                                oldstairid,
           m.f_meter_style                                f_meter_style,
           case p.f_change_type
               when '批量' then '批量调价'
               when '单户' then '单户调价'
               else f_change_type
               end                                        type
    FROM t_pricechange p
        INNER JOIN t_userfiles u ON u.f_userinfo_id = p.f_userinfo_id
        LEFT JOIN t_gasbrand g ON u.f_gasbrand_id = g.id
        LEFT JOIN t_gasmodel m ON u.f_gasmodel_id = m.id
        LEFT JOIN t_stairprice s ON s.id = p.f_newprice_id and u.f_filialeid = s.f_filialeid
    WHERE s.f_state = '有效'
      AND s.${stairPriceSync} = '成功'
      AND sysdate <= s.f_end_date
      AND (p.${setPriceSync} = '未同步' or p.${setPriceSync} is null)
      AND u.f_sendsuccess = '成功'
      AND u.f_table_state IN ('正常' ,'停用')
      AND g.f_alias = '{f_meter_brand}'
      AND g.f_calculation = '表端结算'
) setinfo
