-- 公共SQL：生成调价指令（适用V2，用于先同步气价计划，再通过方案ID调价的情况）
-- 必选参数
-- f_meter_brand：表具品牌别名
-- stairPriceSync：气价方案同步状态字段
-- setPriceSync：调价记录同步状态字段

SELECT
    -- 业务记录ID
    setinfo.id,
    -- 表档案ID
    setinfo.userid,
    -- 表号
    setinfo.f_meternumber,
    -- 卡号
    setinfo.f_card_id,
    -- 新气价ID
    setinfo.stairid,
    -- 旧气价ID
    setinfo.oldstairid,
    -- 调价类型
    setinfo.type
FROM (
    SELECT p.id                                           id,
           u.f_user_id                                    userid,
           u.f_meternumber,
           ISNULL(u.f_card_id, u.f_meternumber)           f_card_id,
           s.id                                           stairId,
           p.f_oldprice_id                                oldstairid,
           '批量调价'                                       type
    FROM t_pricechange p
        LEFT JOIN t_stairprice s ON s.id = p.f_newprice_id
        INNER JOIN t_userfiles u ON u.f_price_id = s.f_price_id and u.f_filialeids = s.f_filialeids
        LEFT JOIN t_gasbrand g ON u.f_gasbrand_id = g.id
    WHERE s.f_state = '有效'
      AND s.${stairPriceSync} = '成功'
      AND getdate() >= s.f_perform_date
      and getdate() <= s.f_end_date
      AND (p.${setPriceSync} IS NULL or p.${setPriceSync} = '未同步')
      AND p.f_change_type = '批量'
      AND u.f_sendsuccess = '成功'
      AND u.f_table_state IN ('正常' ,'停用')
      AND g.f_alias = '{f_meter_brand}'
    UNION ALL
    SELECT p.id                                           id,
           u.f_user_id                                    userid,
           u.f_meternumber,
           ISNULL(u.f_card_id, u.f_meternumber)           f_card_id,
           s.id                                           stairId,
           p.f_oldprice_id                                oldstairid,
           '单表调价'                                       type
    FROM t_pricechange p
        INNER JOIN t_userfiles u ON cast(u.f_userinfo_id as varchar) = p.f_userinfo_id
        LEFT JOIN t_gasbrand g ON u.f_gasbrand_id = g.id
        LEFT JOIN t_stairprice s ON s.id = p.f_newprice_id and u.f_filialeids = s.f_filialeids
    WHERE s.f_state = '有效'
      AND s.${stairPriceSync} = '成功'
      AND getdate() >= s.f_perform_date
      and getdate() <= s.f_end_date
      AND (p.${setPriceSync} IS NULL or p.${setPriceSync} = '未同步')
      AND p.f_change_type = '单户'
      AND u.f_sendsuccess = '成功'
      AND u.f_table_state IN ('正常' ,'停用')
      AND g.f_alias = '{f_meter_brand}'
    ) setinfo
