/*
 * Decompiled with CFR 0.152.
 */
package com.aote.webmeter.common.template.saveInstruct;

import com.aote.webmeter.common.basic.manage.InstructManage;
import com.aote.webmeter.common.basic.manage.param.instructmanage.SaveInstructParam;
import com.aote.webmeter.common.dao.ChangeMeterDataDao;
import com.aote.webmeter.common.dao.SaleDataDao;
import com.aote.webmeter.common.dao.UserFilesDao;
import com.aote.webmeter.common.stereotype.Template;
import com.aote.webmeter.common.template.AbstractTemplate;
import com.aote.webmeter.common.template.AbstractTemplateBuilder;
import com.aote.webmeter.common.template.result.SaveInstructTemplateResult;
import com.aote.webmeter.enums.business.InstructInputtorEnum;
import com.aote.webmeter.enums.business.InstructTypeEnum;
import com.aote.webmeter.tools.SpringBeanUtil;
import com.aote.webmeter.tools.WebMeterInfo;
import java.util.Optional;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Template
public class BasicSaveInstructTemplate
extends AbstractTemplate {
    private static final Logger LOGGER = LoggerFactory.getLogger(BasicSaveInstructTemplate.class);
    protected InstructTypeEnum type;
    protected String userId;
    protected JSONObject content;
    protected String title;
    protected String alias;
    protected InstructInputtorEnum inputtor;
    protected String dataId;
    protected String moduleName;
    protected final InstructManage instructManage;
    protected final UserFilesDao userFilesDao;
    protected final SaleDataDao saleDataDao;
    protected final ChangeMeterDataDao changeMeterDataDao;

    protected BasicSaveInstructTemplate(InstructManage instructManage, UserFilesDao userFilesDao, SaleDataDao saleDataDao, ChangeMeterDataDao changeMeterDataDao) {
        this.instructManage = instructManage;
        this.userFilesDao = userFilesDao;
        this.saleDataDao = saleDataDao;
        this.changeMeterDataDao = changeMeterDataDao;
    }

    @Override
    protected void beforeExec() {
    }

    @Override
    public SaveInstructTemplateResult exec() {
        this.beforeExec();
        if (Optional.ofNullable(this.moduleName).isPresent()) {
            WebMeterInfo.setModuleName(this.moduleName);
        }
        LOGGER.info("----------\u8868\u7f16\u53f7\uff1a{}\u5f00\u59cb\u901a\u8fc7\u6a21\u677f\u4fdd\u5b58{}\u6307\u4ee4--------", (Object)this.userId, (Object)this.type.getValue());
        SaveInstructParam param = new SaveInstructParam.Builder(this.userId, this.type).alias(this.alias).title(this.title).inputtor(this.inputtor).contentData(this.content).dataId(this.dataId).build();
        String instructId = this.instructManage.save(param);
        LOGGER.info("\u901a\u8fc7\u6a21\u677f\u4fdd\u5b58{}\u6307\u4ee4\u6210\u529f\uff0cID:{}", (Object)this.type.getValue(), (Object)instructId);
        this.afterExec();
        return new SaveInstructTemplateResult(instructId);
    }

    @Override
    protected void afterExec() {
    }

    public static class Builder
    extends AbstractTemplateBuilder {
        private final BasicSaveInstructTemplate template = SpringBeanUtil.getBean(BasicSaveInstructTemplate.class);

        public Builder(InstructTypeEnum type, String userId) {
            this.template.type = type;
            this.template.userId = userId;
        }

        @Override
        public BasicSaveInstructTemplate build() {
            this.template.inputtor = Optional.ofNullable(this.template.inputtor).orElse(InstructInputtorEnum.SYSTEM_DEFAULT);
            return this.template;
        }

        public Builder content(JSONObject content) {
            this.template.content = content;
            return this;
        }

        public Builder title(String title) {
            this.template.title = title;
            return this;
        }

        public Builder alias(String alias) {
            this.template.alias = alias;
            return this;
        }

        public Builder inputtor(InstructInputtorEnum inputtor) {
            this.template.inputtor = inputtor;
            return this;
        }

        public Builder dataId(String dataId) {
            this.template.dataId = dataId;
            return this;
        }

        public Builder moduleName(String moduleName) {
            this.template.moduleName = moduleName;
            return this;
        }
    }
}

