/*
 * Decompiled with CFR 0.152.
 */
package com.aote.webmeter.common.basic.manage.param.instructmanage;

import com.af.plugins.DateTools;
import com.aote.webmeter.common.basic.manage.param.AbstractParam;
import com.aote.webmeter.enums.WebmeterPropertiesEnum;
import com.aote.webmeter.enums.business.InstructInputtorEnum;
import com.aote.webmeter.enums.business.InstructStateEnum;
import com.aote.webmeter.enums.business.InstructTypeEnum;
import com.aote.webmeter.tools.WebMeterInfo;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.util.Date;
import java.util.Optional;
import org.json.JSONObject;
import org.springframework.format.annotation.DateTimeFormat;

public class SaveInstructParam
extends AbstractParam {
    private String userId;
    private InstructTypeEnum f_instruct_type;
    private String f_instruct_title;
    private InstructStateEnum f_instruct_state;
    private String f_receive_state;
    private JSONObject f_instruct_content;
    private String f_data_id;
    private String f_meteread_id;
    private String f_alias;
    private InstructInputtorEnum f_inputtor;
    private String f_info;
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private Date f_instruct_date;

    private SaveInstructParam() {
    }

    public String getUserId() {
        return this.userId;
    }

    public InstructTypeEnum getF_instruct_type() {
        return this.f_instruct_type;
    }

    public String getF_instruct_title() {
        return this.f_instruct_title;
    }

    public InstructStateEnum getF_instruct_state() {
        return this.f_instruct_state;
    }

    public String getF_receive_state() {
        return this.f_receive_state;
    }

    public JSONObject getF_instruct_content() {
        return this.f_instruct_content;
    }

    public String getF_data_id() {
        return this.f_data_id;
    }

    public String getF_meteread_id() {
        return this.f_meteread_id;
    }

    public String getF_alias() {
        return this.f_alias;
    }

    public InstructInputtorEnum getF_inputtor() {
        return this.f_inputtor;
    }

    public String getF_info() {
        return this.f_info;
    }

    public Date getF_instruct_date() {
        return this.f_instruct_date;
    }

    public static class Builder {
        private final SaveInstructParam param = new SaveInstructParam();

        public Builder(String userId, InstructTypeEnum typeEnum) {
            this.param.userId = userId;
            this.param.f_instruct_type = typeEnum;
        }

        public SaveInstructParam build() {
            this.param.f_alias = Optional.ofNullable(this.param.f_alias).orElseGet(() -> WebMeterInfo.getString(WebmeterPropertiesEnum.METER_ALIAS));
            this.param.f_instruct_title = Optional.ofNullable(this.param.f_instruct_title).orElseGet(() -> this.param.f_instruct_type.getValue());
            this.param.f_instruct_state = Optional.ofNullable(this.param.f_instruct_state).orElse(InstructStateEnum.READY);
            this.param.f_instruct_content = Optional.ofNullable(this.param.f_instruct_content).orElseGet(JSONObject::new);
            this.param.f_inputtor = Optional.ofNullable(this.param.f_inputtor).orElse(InstructInputtorEnum.SYSTEM_DEFAULT);
            this.param.f_instruct_date = Optional.ofNullable(this.param.f_instruct_date).orElseGet(DateTools::getNow);
            this.param.f_receive_state = Optional.ofNullable(this.param.f_receive_state).orElseGet(() -> this.param.f_instruct_state.getReceiveMsg());
            return this.param;
        }

        public Builder title(String title) {
            this.param.f_instruct_title = title;
            return this;
        }

        public Builder state(InstructStateEnum stateEnum) {
            this.param.f_instruct_state = stateEnum;
            return this;
        }

        public Builder contentData(JSONObject contentData) {
            this.param.f_instruct_content = contentData;
            return this;
        }

        public Builder dataId(String dataId) {
            this.param.f_data_id = dataId;
            return this;
        }

        public Builder metereadId(String metereadId) {
            this.param.f_meteread_id = metereadId;
            return this;
        }

        public Builder alias(String alias) {
            this.param.f_alias = alias;
            return this;
        }

        public Builder inputtor(InstructInputtorEnum inputtor) {
            this.param.f_inputtor = inputtor;
            return this;
        }

        public Builder info(String info) {
            this.param.f_info = info;
            return this;
        }
    }
}

