package com.aote.webmeter.tools.iot;

import com.af.plugins.HttpDeleteWithBody;
import com.aote.webmeter.enums.IOTBusinessTypeEnum;
import com.aote.webmeter.enums.WebmeterPropertiesIOTEnum;
import com.aote.webmeter.tools.WebMeterInfo;
import lombok.SneakyThrows;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.log4j.Logger;
import org.json.JSONObject;

/**
 * 电信IOT平台设备管理工具
 *
 * @author Mr.river
 */
public class DeviceManagementTools {
    private static final Logger LOGGER = Logger.getLogger(DeviceManagementTools.class);

    /**
     * 错误码：设备已被绑定
     */
    private static final String DEVICE_BINDED_1 = "100416";
    private static final String DEVICE_BINDED_2 = "100426";
    private static final String DEVICE_BINDED_3 = "1104";
    /**
     * 错误码：设备已被解绑
     */
    private static final String DEVICE_CANCEL_BINDED_1 = "100403";
    private static final String DEVICE_CANCEL_BINDED_2 = "100418";

    @SneakyThrows
    public static JSONObject regDevice(String nodeId, String name) {
        JSONObject content = new JSONObject();
        content.put("nodeId", nodeId);
        content.put("verifyCode", nodeId);
        content.put("timeout", 0);
        content.put("deviceName", name);

        JSONObject deviceInfo = new JSONObject();
        getDeviceInfo(deviceInfo);

        content.put("deviceInfo", deviceInfo);

        JSONObject result = IotCommonTools.post(IOTBusinessTypeEnum.CREATE_DEVICE, new HttpPost(), content);

        if (result.has("errorEntity")) {
            JSONObject errorEntity = new JSONObject(result.getString("errorEntity"));
            String errorKey = (String) errorEntity.get(IotCommonTools.ERROR_PARAMS_KEY);
            if (DEVICE_BINDED_1.equals(errorKey) || DEVICE_BINDED_2.equals(errorKey) || DEVICE_BINDED_3.equals(errorKey)) {
                return new JSONObject().put("code", -1).put("msg", "尝试注册时已绑定");
            } else {
                return new JSONObject().put("code", -1).put("msg", "注册IOT设备失败：" + errorEntity);
            }
        } else {
            return new JSONObject().put("code", 0).put("msg", result.getString("deviceId"));
        }
    }

    /**
     * 修改设备信息
     *
     * @param deviceId device_id，设备ID
     * @param name     设备名
     * @return 执行结果
     */
    @SneakyThrows
    public static JSONObject modifyDeviceInfo(String deviceId, String name) {
        JSONObject content = new JSONObject();
        content.put("name", name);
        getDeviceInfo(content);

        JSONObject result = IotCommonTools.post(IOTBusinessTypeEnum.MODIFY_DEVICE, new HttpPut(), content, deviceId);

        if (result.has("errorEntity")) {
            JSONObject errorEntity = new JSONObject(result.getString("errorEntity"));
            return new JSONObject().put("code", -1).put("msg", "修改IOT设备失败：" + errorEntity);
        } else {
            return new JSONObject().put("code", 0).put("msg", "成功");
        }
    }

    /**
     * 获取设备信息
     *
     * @param content
     */
    private static void getDeviceInfo(JSONObject content) {
        content.put("manufacturerId", WebMeterInfo.getString(WebmeterPropertiesIOTEnum.MANUFACTURER_ID));
        content.put("manufacturerName", WebMeterInfo.getString(WebmeterPropertiesIOTEnum.MANUFACTURER_NAME));
        content.put("deviceType", WebMeterInfo.getString(WebmeterPropertiesIOTEnum.DEVICE_TYPE));
        content.put("model", WebMeterInfo.getString(WebmeterPropertiesIOTEnum.METER_MODEL));
        content.put("protocolType", "CoAP");
    }

    /**
     * 注销设备
     *
     * @param deviceId device_id，设备ID
     * @return 执行结果
     */
    @SneakyThrows
    public static JSONObject cancelDevice(String deviceId) {
        JSONObject result = IotCommonTools.post(IOTBusinessTypeEnum.MODIFY_DEVICE, new HttpDeleteWithBody(), null, deviceId);

        if (result.has("errorEntity")) {
            JSONObject errorEntity = new JSONObject(result.getString("errorEntity"));
            if (DEVICE_CANCEL_BINDED_1.equals(errorEntity.get(IotCommonTools.ERROR_PARAMS_KEY)) || DEVICE_CANCEL_BINDED_2.equals(errorEntity.get(IotCommonTools.ERROR_PARAMS_KEY))) {
                return new JSONObject().put("code", 0).put("msg", "尝试删除时已不存在");
            }
            return new JSONObject().put("code", -1).put("msg", "删除IOT设备失败：" + errorEntity);
        } else {
            return new JSONObject().put("code", 0).put("msg", "成功");
        }
    }
}
