package com.aote.webmeter.enums.business;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

import java.util.stream.Stream;

/**
 * 物联网表服务 电信物联网对接模式类型
 * @author Mr.river
 */
public enum TelecomDockingModeEnum {
    //OC1
    OC1(0),
    //OC2
    OC2(2),
    //AEP
    AEP(1);

    private Integer value;

    TelecomDockingModeEnum(Integer value) {
        this.value = value;
    }

    @JsonCreator
    public static TelecomDockingModeEnum toType(Integer value) {
        return Stream.of(TelecomDockingModeEnum.values())
                .filter(p -> p.value.equals(value))
                .findAny()
                .orElse(TelecomDockingModeEnum.OC1);
    }

    public static boolean is(Integer value){
        return toType(value) != null;
    }

    @JsonValue
    public Integer getValue(){
        return value;
    }

    private TelecomDockingModeEnum setValue(Integer value){
        this.value = value;
        return this;
    }
}
