package com.aote.webmeter.enums.business;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

import java.util.stream.Stream;

/**
 * 物联网表服务 收费类型
 * @author Mr.river
 */
public enum SaleTypeEnum {
    //充值
    CHARGE("充值"),
    //退费
    REFUND("退费"),
    //冲正
    CANCEL_CHARGE("冲正"),
    //补费
    ADD_FEE("补费"),
    //扣费
    SUB_FEE("扣费"),
    //换表补气
    REPLACE_METER_ADD_VOLUME("换表补气"),
    //充值/退费
    CHARGE_OR_REFUND("充值/退费"),
    //补费/扣费
    ADD_OR_SUB_FEE("补费扣费");

    private final String value;

    SaleTypeEnum(String value) {
        this.value = value;
    }

    @JsonCreator
    public static SaleTypeEnum toType(String value) {
        return Stream.of(SaleTypeEnum.values())
                .filter(p -> p.value.equals(value))
                .findAny()
                .orElse(null);
    }

    public static boolean is(String value){
        return toType(value) != null;
    }

    @JsonValue
    public String getValue(){
        return value;
    }
}
