package com.aote.webmeter.common.dto;

import com.aote.util.JsonHelper;
import com.aote.webmeter.enums.business.IOTDockingModeEnum;
import com.aote.webmeter.enums.business.TelecomDockingModeEnum;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.json.JSONObject;

/**
 * 查询待换表/注销的档案数据-Result
 * 包含以下SQL
 * getChangeMeter@sql
 *
 * @author Mr.river
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class GetChangeMeterDataDto extends GetInstructMetaDataDto {
    /**
     * 业务记录ID
     */
    private String id;
    /**
     * 新表档案ID
     */
    private String userId;
    /**
     * 旧表档案ID
     */
    private String f_userfiles_id_old;
    /**
     * 表档案编号
     */
    private String f_user_id;
    /**
     * 旧表表号
     */
    private String f_meternumber;
    /**
     * 新表表号
     */
    private String f_newmeternumber;
    /**
     * 平台设备号
     */
    private String f_device_id;
    /**
     * 物联网对接模式类型
     */
    private IOTDockingModeEnum f_iot_type;
    /**
     * 电信物联网对接模式类型
     */
    private TelecomDockingModeEnum f_terminal_id;

    private GetChangeMeterDataDto(){

    }

    public static class Builder {
        private final GetChangeMeterDataDto dto;

        public Builder(JSONObject getOpenAccountData) {
            dto = JsonHelper.toParse(getOpenAccountData, GetChangeMeterDataDto.class);
        }

        public GetChangeMeterDataDto build() {
            return dto;
        }
    }
}
