package com.aote.webmeter.enums.business;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

import java.util.stream.Stream;

/**
 * 物联网表服务 表档案状态
 * @author Mr.river
 */
public enum MeterTableStateEnum {
    //正常
    NORMAL("正常"),
    //停用
    DISABLED("停用"),
    //换表
    METER_CHANGE("换表");

    private final String value;

    MeterTableStateEnum(String value) {
        this.value = value;
    }

    @JsonCreator
    public static MeterTableStateEnum toType(String value) {
        return Stream.of(MeterTableStateEnum.values())
                .filter(p -> p.value.equals(value))
                .findAny()
                .orElse(null);
    }

    public static boolean is(String value){
        return toType(value) != null;
    }

    @JsonValue
    public String getValue(){
        return value;
    }
}
