package com.aote.webmeter.common.template.runInstruct;

import com.aote.webmeter.common.basic.manage.InstructManage;
import com.aote.webmeter.common.basic.manage.param.instructmanage.SetInstructStateParam;
import com.aote.webmeter.common.dto.GetInstructDto;
import com.aote.webmeter.common.stereotype.Template;
import com.aote.webmeter.common.template.AbstractTemplate;
import com.aote.webmeter.common.template.AbstractTemplateBuilder;
import com.aote.webmeter.common.template.pour.RunTemplatePour;
import com.aote.webmeter.common.template.pour.RunTemplatePourCall;
import com.aote.webmeter.common.template.pour.param.RunTemplatePourCallParam;
import com.aote.webmeter.common.template.result.RunInstructTemplateResult;
import com.aote.webmeter.enums.business.InstructStateEnum;
import com.aote.webmeter.enums.business.InstructTypeEnum;
import com.aote.webmeter.enums.business.MeterTableStateEnum;
import com.aote.webmeter.tools.SpringBeanUtil;
import com.aote.webmeter.tools.WebMeterInfo;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Optional;

/**
 * 执行指令的基础模板
 * 这是具体业务指令模板的基础形式，应避免直接使用
 * @author Mr.river
 */
@Template
public class BasicRunInstructTemplate extends AbstractTemplate {
    private static final Logger LOGGER = LoggerFactory.getLogger(BasicRunInstructTemplate.class);

    /**
     * 指令类型
     */
    private InstructTypeEnum type;
    /**
     * 需要执行的指令数据
     */
    private GetInstructDto getInstructDto;
    /**
     * 调用执行指令模板时注入业务
     */
    private RunTemplatePour runTemplatePour;
    /**
     * 传入TemplatePour的额外参数
     */
    private JSONObject templatePourExtraParams;
    /**
     * 模块名称，默认通过定时器注入
     */
    private String moduleName;
    /**
     * TemplatePour回调
     */
    private RunTemplatePourCall runTemplatePourCall;
    /**
     * 传入TemplatePour回调的额外参数
     */
    private JSONObject templatePourCallExtraParams;
    /**
     * 指令管理
     */
    private final InstructManage instructManage;

    private BasicRunInstructTemplate(InstructManage instructManage ){
        this.instructManage = instructManage;
    }


    public static class Builder extends AbstractTemplateBuilder{
        private final BasicRunInstructTemplate template;

        public Builder(InstructTypeEnum type, GetInstructDto getInstructDto, RunTemplatePour pour) {
            template = SpringBeanUtil.getBean(BasicRunInstructTemplate.class);
            template.type = type;
            template.getInstructDto = getInstructDto;
            template.runTemplatePour = pour;
        }

        @Override
        public BasicRunInstructTemplate build() {
            return template;
        }

        public Builder moduleName(String moduleName){
            template.moduleName = moduleName;
            return this;
        }

        public Builder templatePourExtraParams(JSONObject templatePourExtraParams){
            template.templatePourExtraParams = templatePourExtraParams;
            return this;
        }

        public Builder templatePourCall(RunTemplatePourCall pourCall){
            template.runTemplatePourCall = pourCall;
            return this;
        }

        public Builder templatePourCallExtraParams(JSONObject pourCallParam){
            template.templatePourCallExtraParams = pourCallParam;
            return this;
        }
    }

    @Override
    protected void beforeExec() {

    }

    @Override
    public RunInstructTemplateResult exec() {
        RunInstructTemplateResult result;
        if(Optional.ofNullable(moduleName).isPresent()){
            //设置模块名
            WebMeterInfo.setModuleName(moduleName);
        }
        String instructTypeValue = getInstructDto.getF_instruct_type().getValue();
        if(Optional.ofNullable(getInstructDto.getF_table_state()).isPresent()
                && getInstructDto.getF_table_state() != MeterTableStateEnum.NORMAL
                && type != InstructTypeEnum.ChangeMeter){
            String receiveMsg = "已自动取消，原因：表档案状态为"+getInstructDto.getF_table_state()+"，" +
                    "预期值：" + MeterTableStateEnum.NORMAL.getValue();
            SetInstructStateParam param = new SetInstructStateParam.Builder(InstructStateEnum.CANCELED)
                    .id(getInstructDto.getId())
                    .receiveMsg(receiveMsg)
                    .build();
            //更改指令状态
            instructManage.setInstructState(param);
            result = new RunInstructTemplateResult.Builder()
                    .state(InstructStateEnum.FAILED)
                    .receiveMsg(receiveMsg)
                    .build();
        } else {
            String meterNumber = getInstructDto.getF_meternumber();
            if(Optional.ofNullable(meterNumber).isPresent()){
                LOGGER.info("----------"+ meterNumber + "开始执行" + instructTypeValue +"指令");
            } else {
                LOGGER.info("----------开始执行" + instructTypeValue +"指令");
            }
            //执行注入的业务
            result = runTemplatePour.run(getInstructDto,templatePourExtraParams);
            if(Optional.ofNullable(runTemplatePourCall).isPresent()){
                RunTemplatePourCallParam param = new RunTemplatePourCallParam.Builder(getInstructDto.getUserId(),
                        getInstructDto.getF_meternumber(), result.getState(), getInstructDto)
                        .extraParams(templatePourCallExtraParams)
                        .build();
                //执行回调业务逻辑
                runTemplatePourCall.run(param);
            }
            if(!result.getDisableUpdate()){
                String metaData = Optional.ofNullable(result.getMetaData())
                        .orElseGet(()-> getInstructDto.getF_instruct_content());
                SetInstructStateParam param = new SetInstructStateParam.Builder(result.getState())
                        .receiveMsg(result.getReceiveMsg())
                        .metaData(metaData)
                        .syncCommandId(result.getSyncCommandId())
                        .id(getInstructDto.getId()).build();
                instructManage.setInstructState(param);
            } else {
                LOGGER.info("禁用更新指令状态");
            }
        }
        LOGGER.info("ID：{}，指令类型：{}，执行完毕：状态：{}，响应信息：{}",getInstructDto.getId(),
                instructTypeValue,result.getState().getValue(),result.getReceiveMsg());
        return result;
    }

    @Override
    protected void afterExec() {

    }
}
