package com.aote.webmeter.common.entity;

import com.aote.util.JsonHelper;
import lombok.Data;
import org.json.JSONObject;

/**
 * 结算抄表记录实体
 *
 * @author Mr.river
 */
@Data
public class SettlementHandPlanEntity {
    private Integer f_meteread_id;
    private Integer f_simplehand_id;
    private Double f_input_gas;
    private Double f_balance_gas;
    private Double f_balance_amount;
    private Double f_oughtamount;
    private Double f_oughtfee;
    private Double f_balance;
    private Double f_curbalance;
    private Double f_tablebase;
    private Double f_last_tablebase;
    private Double f_totaluse_fee;
    private Double f_totalcharge_fee;
    private String f_inputtor;
    private String f_whether_pay;
    private String f_hand_date;
    private String f_input_date;
    private Integer f_price_id;
    private Integer f_stairprice_id;
    private String f_user_name;
    private String f_gasproperties;
    private String f_user_type;
    private String f_meter_classify;
    private Integer f_userinfo_id;
    private String f_userinfo_code;
    private String f_address;
    private Integer f_meternumber;
    private String f_meter_state;
    private String f_accounts_state;
    private String f_hand_state;
    private Integer f_user_id;
    private Integer f_userfiles_id;
    private String f_meter_brand;
    /**
     * 分公司信息
     */
    private String f_filiale;
    private String f_filialeid;
    private String f_filialeids;
    private String f_outlets;
    private String f_orgstr;
    private String f_orgid;
    private String f_depid;
    private String f_orgname;
    private String f_depname;

    private SettlementHandPlanEntity(){

    }

    public static class Builder {
        private final SettlementHandPlanEntity entity;

        public Builder(JSONObject handPlan) {
            entity = JsonHelper.toParse(handPlan, SettlementHandPlanEntity.class);
        }

        public SettlementHandPlanEntity build() {
            return entity;
        }
    }
}
