package com.aote.webmeter.common.dao;

import com.aote.webmeter.common.utils.Condition;
import com.aote.webmeter.enums.DataSourceTypeEnum;
import com.aote.webmeter.tools.WebMeterInfo;

import java.util.Map;

/**
 * 抽象数据库操作类
 *
 * @author Mr.river
 */
public abstract class AbstractDao {

    /**
     * 生成并格式化一条Update语句
     * @param tableName 表名
     * @param params 字段集合
     * @param condition 条件表达式
     * @param isLockOptimize 是否锁优化
     * @return Update语句
     */
    protected String formatUpdateSql(String tableName, Map<String, Object> params,Condition condition,boolean isLockOptimize){
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("\tUPDATE ").append(tableName);
        if (isLockOptimize && WebMeterInfo.getDataSourceTypeEnum() == DataSourceTypeEnum.SQLSERVER){
            sqlBuilder.append(" WITH (READPAST)");
        }
        sqlBuilder.append(" SET");
        params.forEach((key, value)-> {
            String realValue = String.valueOf(value);
            if(!String.valueOf(value).startsWith(Condition.SQL_GRAMMAR_TAG)){
                realValue = "'" + value + "'";
            } else {
                realValue = realValue.substring(1);
            }
            sqlBuilder.append("\n\t  ").append(key).append(" = ").append(realValue).append(",");
        });
        sqlBuilder.deleteCharAt(sqlBuilder.length() - 1);
        sqlBuilder.append("\n\tWHERE ").append(condition.getValue());
        return sqlBuilder.toString();
    }
    protected String formatUpdateSql(String tableName, Map<String, Object> params,Condition condition){
        return formatUpdateSql(tableName,params,condition,false);
    }
}
