package com.aote.webmeter.common.basic.manage.param;

import com.aote.webmeter.common.utils.NecessaryValue;
import com.aote.webmeter.enums.BusinessExceptionCodeEnum;
import com.aote.webmeter.exception.WebmeterException;
import lombok.SneakyThrows;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

/**
 * 抽象参数构造器
 *
 * @author Mr.river
 */
public abstract class AbstractParamBuilder {

    /**
     * 构造
     * @return 抽象参数器
     */
    protected abstract AbstractParam build();

    /**
     * 检查并获取多选一的参数
     * @param param 参数器
     */
    @SneakyThrows
    protected  <K, T> NecessaryValue<K, T> checkAndGetNecessaryParams(AbstractParam param) {
        //获取参数器中的所有属性
        Field[] fields = param.getClass().getDeclaredFields();
        //被NecessaryValue包装的属性名称集合
        List<String> name = new ArrayList<>();
        NecessaryValue<K, T> item = null;
        for (Field field : fields) {
            if (field.getType() == NecessaryValue.class) {
                field.setAccessible(true);
                NecessaryValue<K, T> value = (NecessaryValue<K, T>) field.get(param);
                //如果属性有值
                if (Optional.ofNullable(value).isPresent() && Optional.ofNullable(value.getInValue()).isPresent()) {
                    if (!Optional.ofNullable(item).isPresent() || value.getOrder() < item.getOrder()) {
                        item = value;
                    }
                }
                name.add(field.getName());
            }
        }
        return Optional.ofNullable(item).orElseThrow(()-> new WebmeterException(
                BusinessExceptionCodeEnum.BUSINESS_PARAMS_NOT_FIND,
                "构造["+ param.getClass().getSimpleName() +"]时必须传入以下参数之一：" + name));
    }
}
