package com.aote.webmeter.common.basic.manage;

import com.af.plugins.CommonTools;
import com.af.plugins.DateTools;
import com.af.plugins.JsonTools;
import com.aote.entity.EntityServer;
import com.aote.logic.LogicServer;
import com.aote.sql.SqlServer;
import com.aote.webmeter.enums.DataSourceTypeEnum;
import com.aote.webmeter.enums.SaleVersionEnum;
import com.aote.webmeter.tools.CompatTools;
import com.aote.webmeter.tools.WebMeterInfo;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;

/**
 * 结算管理
 */
@Transactional(rollbackFor=Exception.class)
@Component
public class SettlementManage {

    private static final Logger LOGGER = LoggerFactory.getLogger(SettlementManage.class);

    @Autowired
    private EntityServer entityServer;

    @Autowired
    private LogicServer logicServer;

    @Autowired
    private SqlServer sqlServer;

    /**
     * 物联网表结算
     * @return 生成的指令ID
     */
    public JSONObject settlement(JSONObject params) throws Exception {
        //结算返回结果
        JSONObject result = new JSONObject();
        //是否为忽略首次上报模式
        boolean isFirstIgnore = params.optBoolean("isFirstIgnore",false);
        //是否为日结算模式
        boolean enableDaySettlement = params.optBoolean("enableDaySettlement", false);
        //是否忽略自动下账记录
        boolean disSaveSell = params.optBoolean("disSaveSell",false);
        //获取营收系统版本名
        SaleVersionEnum saleVersion = WebMeterInfo.getSaleNameEnum();
        //表档案ID
        String userId = String.valueOf(params.get("userId"));
        //**********获取结算前所需数据**********
        //查询表具档案
        String condition = CompatTools.getBasicCondition(userId);
        JSONObject userFiles = sqlServer.query("webmeterGetBaseData", new JSONObject()
                .put("items","*")
                .put("tableName","t_userfiles")
                .put("condition",condition)).getJSONObject(0);
        //表档案表号
        String meterNumber = String.valueOf(userFiles.get("f_meternumber"));
        //查询用户档案
        String userInfoId = String.valueOf(userFiles.get("f_userinfo_id"));
        String queryUserItems;
        switch (saleVersion){
            case Vue_V3:
            case Vue_V2:
                queryUserItems = "f_user_name,f_userinfo_code,f_people_num";
                break;
            default:
                queryUserItems = "version,f_balance,f_user_type,f_gasproperties,f_user_name,f_userinfo_code,f_people_num,f_price_id,f_address";
                break;
        }
        JSONObject userInfo = sqlServer.query("webmeterGetBaseData", new JSONObject()
                .put("items",queryUserItems)
                .put("tableName","t_userinfo")
                .put("condition","f_userinfo_id = '" + userInfoId + "'")).getJSONObject(0);
        //查询气表品牌
        String gasBrandId = String.valueOf(userFiles.get("f_gasbrand_id"));
        JSONObject gasBrand = sqlServer.query("webmeterGetBaseData", new JSONObject()
                .put("items","f_meter_brand,f_meter_type")
                .put("tableName","t_gasbrand")
                .put("condition","id = '" + gasBrandId + "'")).getJSONObject(0);
        //**********获取结算前所需数据结束**********
        LOGGER.info("结算追溯：表号{}开始进行结算",meterNumber);
        //表端余额
        double meterBalance = params.optDouble("f_meter_balance",0);
        LOGGER.info("结算追溯：表端或抄表系统返回的余额：{}",meterBalance);
        //上报次数
        int uploadTimes = userFiles.optInt("f_meteread_number",0) + 1;
        //抄表时间
        String handDate = params.getString("f_hand_date");
        //价格编号
        int priceId = userFiles.optInt("f_price_id",0);
        if(priceId == 0){
            priceId = userInfo.optInt("f_price_id",0);
        }
        //**********获取抄表记录基础数据**********
        //用户类型
        String userType;
        //用户性质
        String gasProperties;
        //用户地址
        String address;
        switch (saleVersion){
            case Vue_V3:
            case Vue_V2:
                userType = userFiles.getString("f_user_type");
                gasProperties = userFiles.getString("f_gasproperties");
                //获取用户地址
                if (!userFiles.has("f_useraddress_id")){
                    address = userInfo.optString("f_address","地址信息不存在");
                } else {
                    JSONArray addressList = sqlServer.query("webmeterGetBaseData", new JSONObject()
                            .put("items","f_address")
                            .put("tableName","t_user_address")
                            .put("condition","id = '" + userFiles.get("f_useraddress_id") + "'"));
                    if(addressList.length() > 0){
                        address = addressList.getJSONObject(0).optString("f_address","地址信息为空");
                    } else {
                        address = "地址信息不存在";
                    }
                }
                break;
            case Vue_V1:
            default:
                userType = userInfo.getString("f_user_type");
                gasProperties = userInfo.getString("f_gasproperties");
                address = userInfo.getString("f_address");
                break;
        }
        //**********获取抄表记录基础数据结束**********
        //本次表底数
        double usedGas = params.getDouble("f_tablebase");
        //上次表底数
        double lastUsedGas = params.optDouble("f_last_tablebase",userFiles.optDouble("f_meter_base",0));
        LOGGER.info("结算追溯：本次抄表底数：{},上次抄表底数：{}",usedGas,lastUsedGas);
        //结算前余额
        double balanceValue;
        if(saleVersion == SaleVersionEnum.Vue_V3){
            //表档案余额
            balanceValue = userFiles.optDouble("f_balance_amount",0);
        } else {
            //户档案余额
            balanceValue = userInfo.optDouble("f_balance",0);
        }
        //结算用气量
        Double realUseGas = null;
        //是否存储抄表记录
        boolean isSaveHandPlan = true;
        if(enableDaySettlement){
            //当天日期
            String beginDay = DateTools.getNow("yyyy-MM-dd 00:00:00");
            //比较表档案最近抄表日期和当天日期，如果表档案日期比当天日期大，则认为今天已经抄过表
            boolean isHasToDayHandPlan;
            if(userFiles.has("f_meteread_date")){
                isHasToDayHandPlan = DateTools.compareDate(userFiles.getString("f_meteread_date"), beginDay);
            } else {
                isHasToDayHandPlan = false;
            }
            if(isHasToDayHandPlan || params.optInt("isForceDaySettlement",0) == 1){
                LOGGER.info("结算追溯：进入日结算模式");
                realUseGas = 0.0;
                usedGas = lastUsedGas;
                isSaveHandPlan = false;
            }
        }
        if(isFirstIgnore && userFiles.opt("f_meteread_date") == null){
            LOGGER.info("结算追溯：进入首次上报忽略结算模式");
            realUseGas = 0.0;
            if(params.optBoolean("isCoverLastTableBase",false)){
                lastUsedGas = usedGas;
            }
        }
        if(realUseGas == null) {
            realUseGas = CommonTools.sub(usedGas, lastUsedGas).doubleValue();
        }
        double useGas = realUseGas;
        if(useGas < 0){
            useGas = 0;
        }
        LOGGER.info("结算追溯：实际用气量:{},调整负数后的用气量:{}",realUseGas,useGas);
        //划价结算
        JsonTools.addJSON(result, gasFeeCalculate(useGas, priceId, userFiles, userInfo.opt("f_people_num"), handDate));
        LOGGER.info("结算追溯：结算后汇总信息:{}",result);
        //用气金额
        double chargeNum = result.getDouble("chargenum");
        //结算本次剩余金额
        BigDecimal curBalance = CommonTools.sub(balanceValue,chargeNum);
        LOGGER.info("结算追溯：结算后剩余金额:{}",curBalance);
        //更新本次累计用气金额
        double useGasAmount = userFiles.optDouble("f_total_usegas_amount",0);
        if(isSaveHandPlan) {
            String meterState;
            String chargeState;
            if (usedGas < lastUsedGas) {
                meterState = "未抄表";
                chargeState = "无效";
            } else {
                meterState = "已抄表";
                chargeState = "有效";
            }
            JSONObject handPlan = new JSONObject();
            handPlan.put("f_meteread_id", params.opt("f_meteread_id"));
            handPlan.put("f_simplehand_id", params.opt("f_simplehand_id"));
            handPlan.put("f_input_gas", userFiles.opt("f_input_gas"));
            handPlan.put("f_balance_gas", userFiles.opt("f_balance_gas"));
            handPlan.put("f_balance_amount", curBalance);
            handPlan.put("f_oughtamount", realUseGas);
            handPlan.put("f_oughtfee", chargeNum);
            handPlan.put("f_balance", balanceValue);
            handPlan.put("f_curbalance", curBalance);
            handPlan.put("f_tablebase", usedGas);
            handPlan.put("f_last_tablebase", lastUsedGas);
            handPlan.put("f_totaluse_fee", useGasAmount);
            handPlan.put("f_totalcharge_fee", userFiles.opt("f_total_fee"));
            handPlan.put("f_inputtor", "抄表系统");
            handPlan.put("f_whether_pay", "是");
            handPlan.put("f_hand_date", handDate);
            handPlan.put("f_input_date", DateTools.getNow2());
            handPlan.put("f_price_id", priceId);
            handPlan.put("f_stairprice_id", result.get("priceId"));
            handPlan.put("f_user_name", userInfo.opt("f_user_name"));
            handPlan.put("f_user_type", userType);
            handPlan.put("f_gasproperties", gasProperties);
            handPlan.put("f_user_type", userType);
            handPlan.put("f_meter_classify", "物联网表");
            handPlan.put("f_userinfo_id", userFiles.opt("f_userinfo_id"));
            handPlan.put("f_userinfo_code", userInfo.opt("f_userinfo_code"));
            handPlan.put("f_address", address);
            handPlan.put("f_meternumber", userFiles.opt("f_meternumber"));
            handPlan.put("f_meter_state", meterState);
            //抄表状态
            handPlan.put("f_accounts_state", "自动下账");
            handPlan.put("f_hand_state", "有效");
            //表编号
            handPlan.put("f_user_id", userFiles.opt("f_user_id"));
            handPlan.put("f_userfiles_id", userFiles.opt("f_userfiles_id"));
            //气表品牌
            handPlan.put("f_meter_brand", gasBrand.opt("f_meter_brand"));
            //分公司信息
            handPlan.put("f_filiale", userFiles.opt("f_filiale"));
            handPlan.put("f_filialeids", userFiles.opt("f_filialeids"));
            handPlan.put("f_outlets", userFiles.opt("f_outlets"));
            handPlan.put("f_orgstr", userFiles.opt("f_orgstr"));
            handPlan.put("f_orgid", userFiles.opt("f_orgid"));
            handPlan.put("f_depid", userFiles.opt("f_depid"));
            handPlan.put("f_orgname", userFiles.opt("f_orgname"));
            handPlan.put("f_depname", userFiles.opt("f_depname"));
            //存入抄表记录
            int handPlanId = new JSONObject(entityServer.partialSave("t_handplan", handPlan)).getInt("id");
            //将收费id存入对应的抄表记录,以及对应的价格明细表中
            String chargeType = saleVersion == SaleVersionEnum.Vue_V3 ? "f_type" : "f_charge_type";
            //根据数据源类型区分sql
            DataSourceTypeEnum dataSource = WebMeterInfo.getDataSourceTypeEnum();
            String addChargePriceSql;
            String handDateSql;
            if (dataSource == DataSourceTypeEnum.ORACLE) {
                addChargePriceSql = "INSERT INTO t_chargeprice(id,f_user_id,f_userfiles_id,f_hand_id,f_price_name,f_price,f_gas,f_money," + chargeType + ",f_state,f_operate_date)\n" +
                        "            values (SEQ_CHARGEPRICE_ID.nextval,";
                handDateSql = "to_date('" + handDate + "','yyyy-MM-dd HH24:mi:ss')";
            } else {
                addChargePriceSql = "INSERT INTO t_chargeprice(f_user_id,f_userfiles_id,f_hand_id,f_price_name,f_price,f_gas,f_money," + chargeType + ",f_state,f_operate_date)\n" +
                        "            values (";
                handDateSql = "'" + handDate + "'";
            }
            result.getJSONArray("chargeprice").forEach((item) -> {
                JSONObject itemObject = (JSONObject) item;
                String sql = String.format("%s '%s','%s','%s','%s','%s','%s','%s','抄表划价','%s',%s)",
                        addChargePriceSql, userFiles.get("f_user_id"), userId, handPlanId, itemObject.get("f_price_name"), itemObject.get("f_price"),
                        itemObject.get("f_gas"), itemObject.get("f_money"), chargeState, handDateSql);
                sqlServer.runSQL(sql);
            });
            //V0版本（模块化之前）营收需要存储收费记录
            if (saleVersion == SaleVersionEnum.Vue_V1 && !disSaveSell) {
                JSONObject sellGas = new JSONObject();
                sellGas.put("f_balance", balanceValue);
                sellGas.put("f_curbalance", curBalance);
                sellGas.put("f_tablebase", usedGas);
                sellGas.put("f_last_tablebase", lastUsedGas);
                sellGas.put("f_meter_type", gasBrand.opt("f_meter_type"));
                sellGas.put("f_preamount", chargeNum);
                sellGas.put("f_pregas", useGas);
                sellGas.put("f_payment", "现金缴费");
                sellGas.put("f_price_id", priceId);
                sellGas.put("f_stairprice_id", result.get("priceId"));
                sellGas.put("f_user_id", userFiles.opt("f_user_id"));
                sellGas.put("f_userfiles_id", userFiles.opt("f_userfiles_id"));
                sellGas.put("f_userinfo_id", userInfo.opt("f_userinfo_id"));
                sellGas.put("f_user_name", userInfo.opt("f_user_name"));
                sellGas.put("f_user_type", userType);
                sellGas.put("f_gasproperties", gasProperties);
                sellGas.put("f_meter_classify", "物联网表");
                sellGas.put("userinfo", userInfoId);
                sellGas.put("f_address", address);
                sellGas.put("f_meter_brand", gasBrand.opt("f_meter_brand"));
                sellGas.put("f_meternumber", meterNumber);
                sellGas.put("f_collection", 0);
                sellGas.put("f_delaypay", 0);
                sellGas.put("f_surplus_gas", 0);
                sellGas.put("f_haircut_gas", 0);
                sellGas.put("f_operator", "抄表系统");
                sellGas.put("f_charge_type", "自动下账");
                sellGas.put("f_charge_state", "有效");
                sellGas.put("f_operat_type", "自动下账");
                sellGas.put("f_describe", "用户 :" + userInfo.get("f_user_name") + "进行物联网表收费,自动下账");
                sellGas.put("f_state", "有效");
                sellGas.put("f_delaypay", 0);
                //分公司信息
                sellGas.put("f_filiale", userFiles.opt("f_filiale"));
                sellGas.put("f_filialeids", userFiles.opt("f_filialeids"));
                sellGas.put("f_outlets", userFiles.opt("f_outlets"));
                sellGas.put("f_orgstr", userFiles.opt("f_orgstr"));
                sellGas.put("f_orgid", userFiles.opt("f_orgid"));
                sellGas.put("f_depid", userFiles.opt("f_depid"));
                sellGas.put("f_orgname", userFiles.opt("f_orgname"));
                sellGas.put("f_depname", userFiles.opt("f_depname"));
                //收费ID
                int sellGasId = new JSONObject(entityServer.partialSave("t_sellinggas", sellGas)).getInt("id");
                //更新抄表中的收费id
                sqlServer.run("UPDATE t_handplan SET f_sell_id = '" + sellGasId + "' WHERE id = '" + handPlanId + "'");
                //更新价格明细表中的收费id
                sqlServer.run("UPDATE t_chargeprice SET f_charge_id = '" + sellGasId + "' WHERE f_hand_id = '" + handPlanId + "'");
            }
        }
        if(realUseGas < 0){
            usedGas = lastUsedGas;
        }
        updateUserFiles(userFiles,usedGas,curBalance,uploadTimes,params,handDate,useGasAmount);
        if(saleVersion == SaleVersionEnum.Vue_V1){
            JSONObject userInfoData = new JSONObject();
            userInfoData.put("version", userInfo.get("version"));
            userInfoData.put("f_userinfo_id", userFiles.getString("f_userinfo_id"));
            userInfoData.put("f_balance", curBalance);
            entityServer.partialSave("t_userinfo", userInfoData);
        }
        result.put("lastBalance",balanceValue);
        result.put("balance",curBalance);
        result.put("useGas",usedGas);
        result.put("daySettlementIgnore",enableDaySettlement ? 1 : 0);
        result.put("firstIgnore",isFirstIgnore ? 1 : 0);
        result.put("totalFee",userFiles.opt("f_total_fee"));
        return result;
    }

    /**
     * 更新表档案
     */
    private void updateUserFiles(JSONObject userFiles,double usedGas,BigDecimal curBalance,int uploadTimes,
                                JSONObject params,String handDate, double useGasAmount) throws Exception {
        JSONObject userFilesData = new JSONObject();
        userFilesData.put("version",userFiles.get("version"));
        userFilesData.put("f_user_id",userFiles.get("f_user_id"));
        userFilesData.put("f_userfiles_id",userFiles.opt("f_userfiles_id"));
        userFilesData.put("f_meter_base",usedGas);
        userFilesData.put("f_balance_amount",curBalance);
        userFilesData.put("f_meteread_number",uploadTimes);
        userFilesData.put("f_meteread_maxid",params.opt("f_meteread_maxid"));
        userFilesData.put("f_simplehand_maxid",params.opt("f_simplehand_id"));
        userFilesData.put("f_meteread_date",params.opt("f_insert_date"));
        userFilesData.put("f_hand_date",handDate);
        userFilesData.put("f_total_usegas_amount",useGasAmount);
        entityServer.partialSave("t_userfiles", userFilesData);
    }

    public JSONObject gasFeeCalculate(Object value, Object priceId,JSONObject userFiles, Object peopleNum, String handDate){
        JSONObject params = new JSONObject();
        JSONObject model = new JSONObject();
        model.put("f_price_id",priceId);
        model.put("f_userinfo_id",userFiles.get("f_userinfo_id"));
        model.put("f_user_id",userFiles.get("f_user_id"));
        model.put("userId",userFiles.get(CompatTools.getUserFilesId()));
        model.put("f_open_date",userFiles.opt("f_open_date"));
        params.put("model",model);
        params.put("isGasValue",0);
        params.put("value",value);
        params.put("f_people_num",peopleNum);
        params.put("f_filialeid",userFiles.opt("f_filialeid"));
        params.put("f_orgid",userFiles.opt("f_orgid"));
        params.put("f_filiale",userFiles.opt("f_filiale"));
        params.put("f_filialeids",userFiles.opt("f_filialeids"));
        params.put("f_hand_date",handDate);

        return (JSONObject) logicServer.run("gasfeeCalculate",params);
    }
}
