/*
 * Decompiled with CFR 0.152.
 */
package com.aote.webmeter.tools.iot.onenet;

import com.af.plugins.RestAsyncTools;
import com.af.plugins.RestTools;
import com.aote.webmeter.enums.WebmeterPropertiesIOTEnum;
import com.aote.webmeter.tools.WebMeterInfo;
import com.aote.webmeter.tools.iot.onenet.OnenetApiAuthTools;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OnenetApiService2 {
    private static final Logger LOGGER = LogManager.getLogger(OnenetApiService2.class);
    @Autowired
    private OnenetApiAuthTools onenetApiAuthTools;

    public JSONObject createDevice(String imei, String deviceNo) throws InterruptedException {
        Object msg;
        String path = "https://iot-api.heclouds.com/device/create";
        String productId = WebMeterInfo.getString(WebmeterPropertiesIOTEnum.ONE_NET_PRODUCT_ID);
        JSONObject headers = (JSONObject)this.onenetApiAuthTools.authorization(productId);
        JSONObject params = new JSONObject();
        params.put("product_id", (Object)productId);
        params.put("device_name", (Object)deviceNo);
        params.put("imei", (Object)imei);
        params.put("imsi", (Object)"000000000000000");
        JSONObject result = new JSONObject(RestTools.post((String)path, (String)params.toString(), (String)headers.toString()));
        LOGGER.info("api: {}\uff0cheader: {}\uff0cbody: {}\uff0cresponse: {}\uff0ctype: sync", (Object)path, (Object)headers, (Object)params, (Object)result);
        int errno = result.getInt("code");
        if (errno == 0) {
            msg = result.getJSONObject("data").get("did").toString();
        } else {
            msg = "\u6ce8\u518cIOT\u8bbe\u5907\u5931\u8d25(" + errno + ")\uff1a" + result.getString("msg");
            errno = -1;
        }
        return new JSONObject().put("code", errno).put("msg", msg);
    }

    public JSONObject deleteDevice(String imei) throws InterruptedException {
        Object msg;
        String path = "https://iot-api.heclouds.com/device/delete";
        String productId = WebMeterInfo.getString(WebmeterPropertiesIOTEnum.ONE_NET_PRODUCT_ID);
        JSONObject headers = (JSONObject)this.onenetApiAuthTools.authorization(productId);
        JSONObject params = new JSONObject();
        params.put("product_id", (Object)productId);
        params.put("imei", (Object)imei);
        JSONObject result = new JSONObject(RestTools.post((String)path, (String)params.toString(), (String)headers.toString()));
        LOGGER.info("api: {}\uff0cheader: {}\uff0cbody: {}\uff0cresponse: {}\uff0ctype: sync", (Object)path, (Object)headers, (Object)params, (Object)result);
        int errno = result.getInt("code");
        if (errno == 0) {
            msg = result.getJSONObject("data").get("did").toString();
        } else if (errno == 10410) {
            errno = 0;
            msg = "\u5c1d\u8bd5\u5220\u9664\u65f6\u5df2\u4e0d\u5b58\u5728";
        } else {
            errno = -1;
            msg = "\u5220\u9664IOT\u8bbe\u5907\u5931\u8d25(" + errno + ")\uff1a" + result.getString("msg");
        }
        return new JSONObject().put("code", errno).put("msg", msg);
    }

    public JSONObject writeDeviceRes(String imei, String mode, String timeout, String content) throws InterruptedException {
        JSONObject params = new JSONObject();
        params.put("imei", (Object)imei);
        params.put("obj_id", (Object)WebMeterInfo.getString(WebmeterPropertiesIOTEnum.ONE_NET_OBJECT_ID));
        params.put("obj_inst_id", (Object)WebMeterInfo.getString(WebmeterPropertiesIOTEnum.ONE_NET_OBJECT_INST_ID));
        params.put("mode", mode == null ? Integer.valueOf(1) : mode);
        params.put("timeout", (Object)(timeout == null ? "25" : timeout));
        String path = RestTools.formatURL((String)"https://iot-api.heclouds.com/nb-iot", (JSONObject)params);
        String productId = WebMeterInfo.getString(WebmeterPropertiesIOTEnum.ONE_NET_PRODUCT_ID);
        JSONObject headers = (JSONObject)this.onenetApiAuthTools.authorization(productId);
        JSONObject body = new JSONObject();
        JSONArray data = new JSONArray();
        JSONObject dataItem = new JSONObject();
        dataItem.put("res_id", (Object)WebMeterInfo.getString(WebmeterPropertiesIOTEnum.ONE_NET_RES_ID));
        dataItem.put("type", 1);
        dataItem.put("val", (Object)content);
        data.put((Object)dataItem);
        body.put("data", (Object)data);
        RestAsyncTools.post((String)path, (String)body.toString(), (String)headers.toString());
        LOGGER.info("api: {}\uff0cheader: {}\uff0cbody: {}\uff0ctype: async", (Object)path, (Object)headers, (Object)body);
        return new JSONObject().put("code", 0);
    }

    public JSONObject sendCommand(String imei, String timeout, String content) throws InterruptedException {
        JSONObject params = new JSONObject();
        params.put("imei", (Object)imei);
        params.put("obj_id", (Object)WebMeterInfo.getString(WebmeterPropertiesIOTEnum.ONE_NET_OBJECT_ID));
        params.put("obj_inst_id", (Object)WebMeterInfo.getString(WebmeterPropertiesIOTEnum.ONE_NET_OBJECT_INST_ID));
        params.put("res_id", (Object)WebMeterInfo.getString(WebmeterPropertiesIOTEnum.ONE_NET_RES_ID));
        params.put("timeout", (Object)(timeout == null ? "25" : timeout));
        String path = RestTools.formatURL((String)"https://iot-api.heclouds.com/nb-iot/execute", (JSONObject)params);
        String productId = WebMeterInfo.getString(WebmeterPropertiesIOTEnum.ONE_NET_PRODUCT_ID);
        JSONObject headers = (JSONObject)this.onenetApiAuthTools.authorization(productId);
        JSONObject body = new JSONObject();
        body.put("args", (Object)content);
        RestAsyncTools.post((String)path, (String)body.toString(), (String)headers.toString());
        LOGGER.info("api: {}\uff0cheader: {}\uff0cbody: {}", (Object)path, (Object)headers, (Object)content);
        return new JSONObject().put("code", 0);
    }
}

