/*
 * Decompiled with CFR 0.152.
 */
package com.aote.webmeter.tools;

import com.af.plugins.JsonTools;
import com.aote.redis.RedisUtil;
import org.apache.log4j.Logger;
import org.json.JSONObject;
import org.springframework.stereotype.Component;

@Component
public class MeterDataCacheUtils {
    private static final Logger LOGGER = Logger.getLogger(MeterDataCacheUtils.class);
    private static final String METERINFO_CACHE_KEY = "IotDataCache@";
    private static final Integer METERINFO_CACHE_TIME_VALUE = 300;

    public static String getCacheKey(Object userid, Object version) {
        return "IotDataCache@_" + String.valueOf(userid) + "_" + String.valueOf(version);
    }

    public JSONObject getMeterInfo(Object userid, Object version) {
        String cacheKey;
        RedisUtil redisUtil = RedisUtil.getInstance();
        Object result = redisUtil.get(cacheKey = MeterDataCacheUtils.getCacheKey(userid, version));
        if (result != null) {
            String str = result.toString();
            return new JSONObject(str);
        }
        return null;
    }

    public void setMeterInfo(JSONObject meterInfo) {
        RedisUtil redisUtil = RedisUtil.getInstance();
        Object userid = meterInfo.get("userid");
        Object version = meterInfo.get("version");
        String cacheKey = MeterDataCacheUtils.getCacheKey(userid, version);
        redisUtil.set(cacheKey, (Object)meterInfo.toString(), (long)METERINFO_CACHE_TIME_VALUE.intValue());
    }

    public void updateMeterInfo(Object userid, Object version, JSONObject newMeterInfo) {
        JSONObject oldMeterInfo = this.getMeterInfo(userid, version);
        if (oldMeterInfo != null) {
            JsonTools.addJSON((JSONObject)oldMeterInfo, (JSONObject)newMeterInfo);
            int newVersion = Integer.parseInt(version.toString()) + 1;
            oldMeterInfo.put("version", newVersion);
            this.setMeterInfo(oldMeterInfo);
        }
    }
}

