/*
 * Decompiled with CFR 0.152.
 */
package com.aote.webmeter.tools.iot.utils;

import com.aote.redis.RedisService;
import com.aote.redis.RedisUtil;
import java.io.UnsupportedEncodingException;
import java.util.concurrent.atomic.AtomicReference;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AuthTools<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthTools.class);
    private static final String PUBLIC_ORG_NAME = "Public";

    public final T authorization(String orgId) throws InterruptedException {
        String key;
        Object tokenObj;
        RedisUtil redisService = RedisUtil.getInstance();
        if (orgId == null) {
            orgId = PUBLIC_ORG_NAME;
        }
        if ((tokenObj = redisService.get(key = this.getTokenCacheKey(orgId))) != null) {
            LOGGER.info("{}:\u83b7\u53d6\u73b0\u6709token[{}]\u7684\u7ed3\u679c:{}", new Object[]{this.getName(), key, tokenObj});
            if (tokenObj instanceof String) {
                return (T)new JSONObject(tokenObj.toString());
            }
            return (T)tokenObj;
        }
        String finalOrgId = orgId;
        AtomicReference response = new AtomicReference();
        redisService.lock(key, () -> this.lambda$authorization$0((RedisService)redisService, key, response, finalOrgId));
        return (T)response.get();
    }

    public final T authorization() throws InterruptedException {
        return this.authorization(null);
    }

    public final synchronized void forceRefreshToken(String orgId) throws InterruptedException {
        RedisUtil redisService = RedisUtil.getInstance();
        if (orgId == null) {
            orgId = PUBLIC_ORG_NAME;
        }
        String key = this.getTokenCacheKey(orgId);
        redisService.lock(key, () -> AuthTools.lambda$forceRefreshToken$1((RedisService)redisService, key));
    }

    protected abstract AuthResult getToken(String var1) throws UnsupportedEncodingException;

    private String getTokenCacheKey(String orgId) {
        return this.getName() + "Token@" + orgId;
    }

    protected abstract String getName();

    private static /* synthetic */ void lambda$forceRefreshToken$1(RedisService redisService, String key) {
        redisService.delete(key);
    }

    private /* synthetic */ void lambda$authorization$0(RedisService redisService, String key, AtomicReference response, String finalOrgId) {
        AuthResult result;
        Object newTokenObj = redisService.get(key);
        if (newTokenObj != null) {
            LOGGER.info("{}:\u83b7\u53d6\u73b0\u6709token[{}]\u7684\u7ed3\u679c:{}", new Object[]{this.getName(), key, newTokenObj});
            if (newTokenObj instanceof String) {
                response.set(new JSONObject(newTokenObj.toString()));
            } else {
                response.set(newTokenObj);
            }
            return;
        }
        LOGGER.info("{}\u5e73\u53f0\uff1a{}:\u8fdb\u884c\u9274\u6743\u64cd\u4f5c", (Object)this.getName(), (Object)key);
        try {
            result = this.getToken(finalOrgId);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        LOGGER.info(result.value.getClass().getName());
        redisService.set(key, result.value, (long)result.expiresIn.intValue());
        response.set(result.value);
    }

    protected final class AuthResult {
        private final T value;
        private final Integer expiresIn;

        public AuthResult(AuthTools this$0, T value, Integer expiresIn) {
            this.value = value;
            this.expiresIn = expiresIn;
        }
    }
}

