/*
 * Decompiled with CFR 0.152.
 */
package com.aote.webmeter.tools.iot.onenet;

import com.aote.webmeter.tools.WebMeterInfo;
import com.aote.webmeter.tools.iot.utils.AuthTools;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class OnenetApiAuthTools
extends AuthTools<JSONObject> {
    private static final Logger LOGGER = LoggerFactory.getLogger(OnenetApiAuthTools.class);
    private static final Integer TOKEN_TIMEOUT_VALUE = 3600;

    @Override
    protected AuthTools.AuthResult getToken(String orgId) throws UnsupportedEncodingException {
        String version = "2022-05-01";
        String resourceName = "products/" + WebMeterInfo.getString("onenetProductId");
        String expirationTime = "" + (System.currentTimeMillis() / 1000L + 8640000L);
        String signatureMethod = SignatureMethod.SHA1.name().toLowerCase();
        String accessKey = WebMeterInfo.getString("onenetProductAccessKey");
        StringBuilder sb = new StringBuilder();
        String res = URLEncoder.encode(resourceName, String.valueOf(StandardCharsets.UTF_8));
        String encryptText = expirationTime + "\n" + signatureMethod + "\n" + resourceName + "\n" + version;
        byte[] bytes = null;
        try {
            bytes = OnenetApiAuthTools.HmacEncrypt(encryptText, accessKey, signatureMethod);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        String signature = Base64.getEncoder().encodeToString(bytes);
        String sig = URLEncoder.encode(signature, String.valueOf(StandardCharsets.UTF_8));
        sb.append("version=").append(version).append("&res=").append(res).append("&et=").append(expirationTime).append("&method=").append(signatureMethod).append("&sign=").append(sig);
        JSONObject header = new JSONObject();
        header.put("Authorization", (Object)sb.toString());
        return new AuthTools.AuthResult(this, header, TOKEN_TIMEOUT_VALUE - 60);
    }

    private static byte[] HmacEncrypt(String data, String key, String signatureMethod) throws NoSuchAlgorithmException, InvalidKeyException {
        SecretKeySpec signinKey = new SecretKeySpec(Base64.getDecoder().decode(key), "Hmac" + signatureMethod.toUpperCase());
        Mac mac = Mac.getInstance("Hmac" + signatureMethod.toUpperCase());
        mac.init(signinKey);
        return mac.doFinal(data.getBytes());
    }

    @Override
    protected String getName() {
        return "Onenet";
    }

    public static enum SignatureMethod {
        SHA1,
        MD5,
        SHA256;

    }
}

