/*
 * Decompiled with CFR 0.152.
 */
package com.aote.webmeter.tools;

import com.af.plugins.CommonTools;
import com.aote.webmeter.enums.ModuleEnum;
import com.aote.webmeter.enums.WebmeterExceptionCodeEnum;
import com.aote.webmeter.exception.WebmeterException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class WebmeterPropertiesTools {
    public static HashMap<String, String> readWebMeter(String path, String moduleName) {
        path = !ModuleEnum.PUBLIC_MODULE.getValue().equals(moduleName) ? (!"".equals(path) ? (String)path + "/" + moduleName + "/webmeter.properties" : moduleName + "/webmeter.properties") : "webmeter.properties";
        Properties props = new Properties();
        InputStream proStream = WebmeterPropertiesTools.class.getClassLoader().getResourceAsStream((String)path);
        if (proStream == null) {
            return null;
        }
        InputStreamReader propertiesAsStream = new InputStreamReader(proStream);
        try {
            props.load(propertiesAsStream);
        }
        catch (IOException e) {
            throw new WebmeterException(WebmeterExceptionCodeEnum.CONFIG_FAIL, "\u6a21\u5757\uff1a" + moduleName);
        }
        Set<Object> keys = props.keySet();
        HashMap<String, String> params = new HashMap<String, String>(keys.size());
        for (Object k : keys) {
            String keyStr = k.toString();
            String value = CommonTools.parametricStr((String)props.getProperty(keyStr), (Map)props);
            params.put(keyStr, value);
        }
        return params;
    }

    public static HashMap<String, String> readWebMeter(String moduleName) {
        return WebmeterPropertiesTools.readWebMeter("", moduleName);
    }
}

