/*
 * Decompiled with CFR 0.152.
 */
package com.aote.webmeter.socket;

import com.aote.webmeter.socket.config.SocketConfig;
import com.aote.webmeter.socket.config.SocketConfigItem;
import com.aote.webmeter.socket.core.server.SocketServer;
import com.aote.webmeter.socket.core.server.tcp.TcpServer;
import com.aote.webmeter.socket.core.server.udp.UdpServer;
import com.aote.webmeter.socket.enums.SocketTypeEnum;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class SocketServerManager
implements ApplicationContextAware {
    public static ApplicationContext applicationContext;
    private static final Map<String, SocketConfigItem> socketConfigMap;
    private final List<SocketServer<?, ?>> socketServerList = new ArrayList();

    public static SocketConfigItem getSocketConfigItemByPort(String port) {
        return socketConfigMap.get(port);
    }

    @PostConstruct
    public void startAll() {
        List<SocketConfigItem> socketConfigItemList = SocketConfig.getSocketServerList();
        if (socketConfigItemList != null) {
            socketConfigItemList.forEach(item -> {
                SocketServer<?, ?> socketServer = this.createSocketServer((SocketConfigItem)item);
                this.socketServerList.add(socketServer);
                item.getPort().forEach(port -> socketConfigMap.put(port.toString(), (SocketConfigItem)item));
                if (socketServer != null) {
                    socketServer.run((SocketConfigItem)item);
                }
            });
        }
    }

    private SocketServer<?, ?> createSocketServer(SocketConfigItem item) {
        SocketServer socketServer = null;
        if (item.getType() == SocketTypeEnum.TCP) {
            socketServer = new TcpServer();
        } else if (item.getType() == SocketTypeEnum.UDP) {
            socketServer = new UdpServer();
        }
        return socketServer;
    }

    @PreDestroy
    public void destroyAll() {
        for (SocketServer<?, ?> socketServer : this.socketServerList) {
            socketServer.destroy();
        }
    }

    public void setApplicationContext(ApplicationContext atx) throws BeansException {
        applicationContext = atx;
    }

    static {
        socketConfigMap = new HashMap<String, SocketConfigItem>();
    }
}

