/*
 * Decompiled with CFR 0.152.
 */
package com.aote.webmeter.tools.iot.onenet;

import com.af.plugins.ConvertTools;
import com.aote.webmeter.enums.WebmeterPropertiesIOTEnum;
import com.aote.webmeter.tools.WebMeterInfo;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.Provider;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.json.JSONObject;
import org.springframework.stereotype.Component;

@Component
public class OnenetTools {
    public JSONObject decodeCallBackData(String encodeStr) {
        byte[] plainMsg;
        byte[] aesMsg = ConvertTools.base64Decode((byte[])encodeStr.getBytes(StandardCharsets.UTF_8));
        String encodingAESKey = WebMeterInfo.getString(WebmeterPropertiesIOTEnum.ONE_NET_ENCODING_AES_KEY);
        byte[] password = this.isNewVersion() ? encodingAESKey.getBytes(StandardCharsets.UTF_8) : ConvertTools.base64Decode((byte[])(encodingAESKey + "=").getBytes(StandardCharsets.UTF_8));
        try {
            plainMsg = OnenetTools.decrypt(aesMsg, password);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        String str = new String(plainMsg, StandardCharsets.UTF_8);
        return new JSONObject(str.substring(str.indexOf("{")));
    }

    private static byte[] decrypt(byte[] encrypted, byte[] password) throws Exception {
        byte[] bs = new byte[16];
        System.arraycopy(password, 0, bs, 0, 16);
        IvParameterSpec zeroIv = new IvParameterSpec(bs);
        SecretKeySpec key = new SecretKeySpec(password, "AES");
        Security.addProvider((Provider)new BouncyCastleProvider());
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS7Padding");
        cipher.init(2, (Key)key, zeroIv);
        return cipher.doFinal(encrypted);
    }

    public boolean isNewVersion() {
        return WebMeterInfo.has(WebmeterPropertiesIOTEnum.ONE_NET_PRODUCT_ID);
    }
}

