/*
 * Decompiled with CFR 0.152.
 */
package com.aote.webmeter.timer;

import com.aote.sql.SqlServer;
import com.aote.webmeter.enums.DataSourceTypeEnum;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class InstructSyncTimerMain {
    @Autowired
    private SqlServer sqlServer;

    public void run(DataSourceTypeEnum dataSourceTypeEnum, String instructTableName, String topSQL) throws Exception {
        if (dataSourceTypeEnum == DataSourceTypeEnum.ORACLE) {
            this.sqlServer.runSQL("BEGIN\n  EXECUTE IMMEDIATE 'DROP TABLE temp_history_instruct';\n  EXCEPTION\n  WHEN OTHERS THEN\n  NULL; -- \u5982\u679c\u8868\u4e0d\u5b58\u5728\uff0c\u5219\u5ffd\u7565\u5f02\u5e38\nEND;");
            this.sqlServer.runSQL(String.format("CREATE GLOBAL TEMPORARY TABLE temp_history_instruct AS SELECT * FROM ( %s ) a", topSQL));
            this.sqlServer.runSQL("INSERT INTO t_instruct_history SELECT * FROM temp_history_instruct");
            this.sqlServer.runSQL("DELETE FROM " + instructTableName + " WHERE id IN (SELECT id FROM temp_history_instruct)");
            this.sqlServer.runSQL("DROP TABLE temp_history_instruct");
        } else if (dataSourceTypeEnum == DataSourceTypeEnum.SQLSERVER) {
            this.sqlServer.runSQL(String.format("DROP TABLE IF EXISTS ##temp_history_instruct;\nSELECT * INTO ##temp_history_instruct FROM ( %s ) a;\nINSERT INTO t_instruct_history SELECT * FROM ##temp_history_instruct;\nDELETE FROM " + instructTableName + " WHERE id IN ( SELECT id FROM ##temp_history_instruct);", topSQL));
        } else {
            this.sqlServer.runSQL("execMigrationInstruct", new Object[]{String.format("DROP TEMPORARY TABLE IF EXISTS temp_history_instruct;\nCREATE TEMPORARY TABLE temp_history_instruct %s;\nINSERT INTO t_instruct_history SELECT * FROM temp_history_instruct;\nDELETE FROM " + instructTableName + " WHERE id IN ( SELECT id FROM temp_history_instruct);", topSQL)});
        }
    }
}

