/*
 * Decompiled with CFR 0.152.
 */
package com.aote.webmeter.timer;

import com.aote.sql.SqlServer;
import com.aote.webmeter.enums.DataSourceTypeEnum;
import com.aote.webmeter.timer.InstructSyncTimerMain;
import com.aote.webmeter.tools.CompatTools;
import com.aote.webmeter.tools.WebMeterInfo;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@Profile(value={"prod"})
public class InstructSyncTimer {
    private static final Logger LOG_MANAGER = LogManager.getLogger(InstructSyncTimer.class);
    private static final int PAGE_SIZE = 1000;
    @Autowired
    private SqlServer sqlServer;
    @Autowired
    private InstructSyncTimerMain timerMain;

    @Scheduled(cron="0 17 9,17,21 * * ?")
    public void runDataSync() throws Exception {
        LOG_MANAGER.info("=====\u5f00\u59cb\u8fc1\u79fb\u5386\u53f2\u6307\u4ee4=====");
        String instructTableName = CompatTools.getInstructTableName();
        DataSourceTypeEnum dataSourceTypeEnum = WebMeterInfo.getDataSourceTypeEnum();
        String whereClause = "WHERE f_instruct_state IN ('\u6267\u884c\u6210\u529f', '\u6267\u884c\u5931\u8d25', '\u5ffd\u7565\u5197\u4f59', '\u65e0\u54cd\u5e94', '\u5df2\u53d6\u6d88') OR (f_instruct_state = '\u54cd\u5e94\u8d85\u65f6' AND f_inputtor IN ('\u7cfb\u7edf\u751f\u6210','\u7cfb\u7edf\u6863\u6848\u6d41\u7a0b'))";
        String countSql = "SELECT COUNT(*) total FROM " + instructTableName + " " + whereClause;
        int totalCount = this.sqlServer.querySQL(countSql).getJSONObject(0).getInt("total");
        LOG_MANAGER.info("\u9700\u8981\u8fc1\u79fb\u7684\u5386\u53f2\u6307\u4ee4\u603b\u6570: {}", (Object)totalCount);
        if (totalCount == 0) {
            LOG_MANAGER.info("\u6ca1\u6709\u9700\u8981\u8fc1\u79fb\u7684\u5386\u53f2\u6307\u4ee4");
            return;
        }
        int totalPages = (totalCount + 1000 - 1) / 1000;
        int processedCount = 0;
        int batchCount = 0;
        while (processedCount < totalCount) {
            LOG_MANAGER.info("\u5f00\u59cb\u5904\u7406\u7b2c {} \u6279\uff0c\u5171\u9700\u5904\u7406\u7ea6 {} \u6279", (Object)(++batchCount), (Object)totalPages);
            String topSQL = this.generatePageSQL(instructTableName, whereClause, 1000, dataSourceTypeEnum);
            this.timerMain.run(dataSourceTypeEnum, instructTableName, topSQL);
            LOG_MANAGER.info("\u5df2\u5904\u7406 {} \u6761\u8bb0\u5f55\uff0c\u603b\u8ba1 {} \u6761", (Object)(processedCount += 1000), (Object)totalCount);
        }
        LOG_MANAGER.info("\u6307\u4ee4\u8fc1\u79fb\u5b8c\u6210\uff0c\u5171\u5904\u7406 {} \u6761\u8bb0\u5f55", (Object)processedCount);
    }

    private String generatePageSQL(String tableName, String whereClause, int limit, DataSourceTypeEnum dbType) {
        switch (dbType) {
            case ORACLE: {
                return String.format("SELECT * FROM (SELECT * FROM " + tableName + " %s) WHERE ROWNUM <= %d", whereClause, limit);
            }
            case SQLSERVER: {
                return String.format("SELECT TOP %d * FROM " + tableName + " %s", limit, whereClause);
            }
        }
        return String.format("SELECT * FROM " + tableName + " %s LIMIT %d", whereClause, limit);
    }
}

