/*
 * Decompiled with CFR 0.152.
 */
package com.aote.webmeter.mq;

import com.aote.redis.RedisUtil;
import com.aote.rs.LogicService;
import com.aote.rs.mapper.WebException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.rocketmq.client.consumer.listener.ConsumeConcurrentlyContext;
import org.apache.rocketmq.client.consumer.listener.ConsumeConcurrentlyStatus;
import org.apache.rocketmq.client.consumer.listener.MessageListenerConcurrently;
import org.apache.rocketmq.common.message.MessageExt;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;

public class IOTMessageListener
implements MessageListenerConcurrently {
    private static final Logger LOGGER = Logger.getLogger(IOTMessageListener.class);
    private static final RedisUtil redisUtil = RedisUtil.getInstance();
    @Autowired
    private LogicService logicService;

    public ConsumeConcurrentlyStatus consumeMessage(List<MessageExt> msgs, ConsumeConcurrentlyContext context) {
        for (MessageExt msg : msgs) {
            String logicName = msg.getTags();
            String body = new String(msg.getBody(), StandardCharsets.UTF_8);
            try {
                JSONObject bodyObj = new JSONObject(body);
                LOGGER.info((Object)("mq\uff1a" + bodyObj));
                if (bodyObj.has("deviceId")) {
                    String deviceId = bodyObj.getString("deviceId");
                    redisUtil.lock(deviceId, Integer.valueOf(5), Integer.valueOf(30), () -> this.runLogic(logicName, body));
                    continue;
                }
                this.runLogic(logicName, body);
            }
            catch (WebException e) {
                this.runLogic(logicName + "LowerRank", body);
            }
            catch (Exception e) {
                LOGGER.error((Object)("\u3010" + logicName + "\u3011\u51fa\u73b0\u5f02\u5e38\uff1a"), (Throwable)e);
            }
        }
        return ConsumeConcurrentlyStatus.CONSUME_SUCCESS;
    }

    private void runLogic(String logicName, String data) {
        try {
            this.logicService.xtSave(logicName, data);
        }
        catch (Exception e) {
            LOGGER.error((Object)("\u3010" + logicName + "\u3011\u51fa\u73b0\u5f02\u5e38\uff1a"), (Throwable)e);
        }
    }
}

