/*
 * Decompiled with CFR 0.152.
 */
package com.aote.webmeter.tools.iot;

import com.af.plugins.HttpConnectionPoolUtil;
import com.aote.webmeter.enums.IOTBusinessTypeEnum;
import com.aote.webmeter.enums.WebmeterPropertiesIOTEnum;
import com.aote.webmeter.tools.WebMeterInfo;
import com.aote.webmeter.tools.iot.AuthenticationTools;
import com.aote.webmeter.tools.iot.TelecomApi;
import java.io.IOException;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class IotCommonTools {
    private static final Logger LOGGER = Logger.getLogger(IotCommonTools.class);
    private static final ThreadLocal<Integer> IS_AEP = new ThreadLocal();
    public static final String ERROR_PARAMS_KEY = "error_code";

    public static JSONObject post(IOTBusinessTypeEnum typeEnum, HttpEntityEnclosingRequestBase base, JSONObject contentObj) throws IOException {
        return IotCommonTools.post(typeEnum, base, contentObj, null);
    }

    public static JSONObject post(IOTBusinessTypeEnum typeEnum, HttpEntityEnclosingRequestBase base, JSONObject contentObj, String urlAppend) throws IOException {
        JSONObject result;
        String responseBody;
        String url;
        int isAep = IotCommonTools.getIsAep();
        String header = null;
        String content = null;
        if (typeEnum != IOTBusinessTypeEnum.AUTH) {
            JSONObject headerObj = new JSONObject();
            if (typeEnum != IOTBusinessTypeEnum.REFRESH_AUTH) {
                String accessToken = AuthenticationTools.getAuthToken();
                String appId = isAep == 1 ? WebMeterInfo.getString(WebmeterPropertiesIOTEnum.AEP_APIKEY) : (isAep == 0 ? WebMeterInfo.getString(WebmeterPropertiesIOTEnum.OC_APIKEY) : WebMeterInfo.getString(WebmeterPropertiesIOTEnum.OC2_APIKEY));
                headerObj.put("app_key", (Object)appId);
                headerObj.put("Authorization", (Object)("Bearer " + accessToken));
            }
            headerObj.put("Content-Type", (Object)"application/json");
            header = headerObj.toString();
        }
        if (contentObj != null) {
            content = contentObj.toString();
        }
        switch (typeEnum) {
            case AUTH: {
                url = TelecomApi.getAuthUrl();
                break;
            }
            case REFRESH_AUTH: {
                url = TelecomApi.getRefreshAuthUrl();
                break;
            }
            case CREATE_DEVICE: {
                url = TelecomApi.getDeviceCreateUrl();
                break;
            }
            case MODIFY_DEVICE: 
            case REMOVE_DEVICE: {
                url = TelecomApi.getDeviceUpdateUrl() + "/" + urlAppend;
                break;
            }
            case SEND_COMMAND: {
                url = TelecomApi.getSendInstructUrl();
                break;
            }
            case SUBSCRIPTIONS: {
                url = TelecomApi.getSubscriptionsUrl();
                break;
            }
            default: {
                throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u4e1a\u52a1\u7c7b\u578b\uff1a" + typeEnum.name());
            }
        }
        CloseableHttpClient client = url.startsWith("https://") ? AuthenticationTools.getHttpClient() : HttpConnectionPoolUtil.getHttpClient();
        if (typeEnum == IOTBusinessTypeEnum.AUTH) {
            assert (contentObj != null);
            LOGGER.debug((Object)("\u8bf7\u6c42\u7684\u5730\u5740\uff1a" + url));
            LOGGER.debug((Object)("\u8bf7\u6c42\u4f53\uff1a" + content));
            responseBody = HttpConnectionPoolUtil.requestFormUrlEncoded((String)url, (JSONObject)contentObj, (HttpEntityEnclosingRequestBase)base, (CloseableHttpClient)client);
        } else {
            LOGGER.debug((Object)("\u8bf7\u6c42\u7684\u5730\u5740\uff1a" + url));
            LOGGER.debug((Object)("\u8bf7\u6c42\u5934\uff1a" + header));
            LOGGER.debug((Object)("\u8bf7\u6c42\u4f53\uff1a" + content));
            responseBody = HttpConnectionPoolUtil.request((String)url, (String)content, (String)header, (HttpRequestBase)base, (CloseableHttpClient)client);
        }
        if (responseBody != null) {
            try {
                result = new JSONObject(responseBody);
            }
            catch (JSONException ignore) {
                result = new JSONObject();
                result.put("value", (Object)responseBody);
            }
        } else {
            result = new JSONObject();
        }
        LOGGER.debug((Object)("\u8c03\u7528\u5e73\u53f0API\u7ed3\u679c\uff1a" + result));
        return result;
    }

    public static void removeIsAep() {
        IS_AEP.remove();
    }

    public static void setIsAep(Object isAep) {
        if (isAep == null) {
            isAep = 0;
        }
        IS_AEP.set(Integer.valueOf(String.valueOf(isAep)));
    }

    public static Integer getIsAep() {
        Integer b = IS_AEP.get();
        if (b == null) {
            return 0;
        }
        return b;
    }
}

