/*
 * Decompiled with CFR 0.152.
 */
package com.aote.webmeter.tools;

import com.aote.webmeter.enums.SaleVersionEnum;
import com.aote.webmeter.enums.business.OpenAccountStateEnum;
import com.aote.webmeter.tools.WebMeterInfo;
import org.json.JSONObject;

public class CompatTools {
    public static String getBasicCondition(Object userId) {
        String userIdValue = String.valueOf(userId);
        switch (WebMeterInfo.getSaleNameEnum()) {
            case Vue_V1: 
            case Vue_V2: {
                return "t_userfiles.f_user_id = '" + userIdValue + "'";
            }
            case SILVER_LIGHT: 
            case SILVER_LIGHT2: {
                return "t_userfiles.id = '" + userIdValue + "'";
            }
        }
        return "t_userfiles.f_userfiles_id = '" + userIdValue + "'";
    }

    public static String getBasicCondition(JSONObject object) {
        switch (WebMeterInfo.getSaleNameEnum()) {
            case Vue_V1: 
            case Vue_V2: {
                return "t_userfiles.f_user_id = '" + object.getString("f_user_id") + "'";
            }
            case SILVER_LIGHT: 
            case SILVER_LIGHT2: {
                return "t_userfiles.id = '" + object.getString("f_user_id") + "'";
            }
        }
        return "t_userfiles.f_userfiles_id = '" + object.getString("f_userfiles_id") + "'";
    }

    public static String getUpdateChangeMeterSql(Object id, Boolean isSuccess) {
        String idValue = String.valueOf(id);
        String syncWorld = isSuccess != false ? "\u6210\u529f" : "\u5931\u8d25";
        switch (WebMeterInfo.getSaleNameEnum()) {
            case Vue_V1: 
            case Vue_V2: {
                return "UPDATE t_changemeter SET f_sendsuccess = '" + syncWorld + "' WHERE id = '" + idValue + "'";
            }
            case SILVER_LIGHT: 
            case SILVER_LIGHT2: {
                return "UPDATE t_changmeter SET f_sendsuccess = '" + syncWorld + "' WHERE id = '" + idValue + "'";
            }
        }
        return "UPDATE t_changetables SET f_sendsuccess = '" + syncWorld + "' WHERE id = '" + idValue + "'";
    }

    public static String getUpdateChangeMeterSql(Object id) {
        return CompatTools.getUpdateChangeMeterSql(id, true);
    }

    public static String getUpdateSetPriceMeterSql(Object id, String updateColumns) {
        if (updateColumns == null) {
            updateColumns = "f_sendsuccess";
        }
        String idValue = String.valueOf(id);
        switch (WebMeterInfo.getSaleNameEnum()) {
            case SILVER_LIGHT: {
                return "UPDATE t_changestairpricedetail SET " + updateColumns + " = '\u6210\u529f' where id = '" + idValue + "'";
            }
            case SILVER_LIGHT2: {
                return "UPDATE t_changestairprice SET " + updateColumns + " = '\u6210\u529f' where id = '" + idValue + "'";
            }
        }
        return "UPDATE t_pricechange SET " + updateColumns + " = '\u6210\u529f' WHERE id = '" + idValue + "'";
    }

    public static String getUpdateChargeMeterSql(Object id, Boolean isSuccess) {
        String idValue = String.valueOf(id);
        String syncWorld = isSuccess != false ? "\u6210\u529f" : "\u5931\u8d25";
        return "UPDATE t_sellinggas SET f_sendsuccess = '" + syncWorld + "' WHERE id = '" + idValue + "'";
    }

    public static String getUpdateChargeMeterSql(Object id) {
        return CompatTools.getUpdateChargeMeterSql(id, true);
    }

    public static String getUpdateCancelChargeMeterSql(Object id, Boolean isSuccess) {
        String idValue = String.valueOf(id);
        String syncWorld = isSuccess != false ? "\u6210\u529f" : "\u5931\u8d25";
        switch (WebMeterInfo.getSaleNameEnum()) {
            case SILVER_LIGHT: 
            case SILVER_LIGHT2: {
                return "UPDATE t_correctrecord SET f_sendsuccess = '" + syncWorld + "' WHERE id = '" + idValue + "'";
            }
        }
        return "UPDATE t_sellinggas SET f_sendsuccess = '" + syncWorld + "' WHERE id = '" + idValue + "'";
    }

    public static String getUpdateCancelChargeMeterSql(Object id) {
        return CompatTools.getUpdateCancelChargeMeterSql(id, true);
    }

    public static String getUpdateSupplyGasMeterSql(Object id, Boolean isSuccess) {
        String idValue = String.valueOf(id);
        String syncWorld = isSuccess != false ? "\u6210\u529f" : "\u5931\u8d25";
        switch (WebMeterInfo.getSaleNameEnum()) {
            case SILVER_LIGHT: 
            case SILVER_LIGHT2: {
                return "UPDATE t_changmeter SET f_isSupplyGas = '" + syncWorld + "' WHERE id = '" + idValue + "'";
            }
        }
        return "UPDATE t_fillgas SET f_sendsuccess = '" + syncWorld + "' WHERE id = '" + idValue + "'";
    }

    public static String getUpdateSupplyGasMeterSql(Object id) {
        return CompatTools.getUpdateSupplyGasMeterSql(id, true);
    }

    public static String getUpdateAdjustMoneyMeterSql(Object id, Boolean isSuccess) {
        String idValue = String.valueOf(id);
        String syncWorld = isSuccess != false ? "\u6210\u529f" : "\u5931\u8d25";
        switch (WebMeterInfo.getSaleNameEnum()) {
            case SILVER_LIGHT: 
            case SILVER_LIGHT2: {
                return "UPDATE t_cbgas SET f_sendsuccess = '" + syncWorld + "' WHERE id = '" + idValue + "'";
            }
        }
        return "UPDATE t_fillgas SET f_sendsuccess = '" + syncWorld + "' WHERE id = '" + idValue + "'";
    }

    public static String getUpdateAdjustMoneyMeterSql(Object id) {
        return CompatTools.getUpdateAdjustMoneyMeterSql(id, true);
    }

    public static String getUpdateSyncAreasSql(JSONObject object) {
        switch (WebMeterInfo.getSaleNameEnum()) {
            case SILVER_LIGHT: 
            case SILVER_LIGHT2: {
                String paramsValue = String.valueOf(object.get("f_districtname"));
                return "UPDATE t_userfiles SET f_isSyncAreas = '\u6210\u529f' WHERE f_districtname = '" + paramsValue + "'";
            }
        }
        String paramsValue = String.valueOf(object.get("id"));
        return "UPDATE t_area SET f_sendsuccess = '\u6210\u529f' WHERE id = '" + paramsValue + "'";
    }

    public static String getUpdateSyncAddressSql(JSONObject object) {
        switch (WebMeterInfo.getSaleNameEnum()) {
            case SILVER_LIGHT: 
            case SILVER_LIGHT2: {
                String paramsValue = String.valueOf(object.get("f_address"));
                return "UPDATE t_userfiles SET f_isSyncAddress = '\u6210\u529f' WHERE f_address = '" + paramsValue + "'";
            }
        }
        String paramsValue = String.valueOf(object.get("id"));
        return "UPDATE t_user_address SET f_sendsuccess = '\u6210\u529f' WHERE id = '" + paramsValue + "'";
    }

    @Deprecated
    public static String getUpdateUserFilesSql(Object userId, Boolean isOpenAccount) {
        OpenAccountStateEnum stateEnum = isOpenAccount != false ? OpenAccountStateEnum.OPEN_ACCOUNT : OpenAccountStateEnum.NO_ACCOUNT;
        return CompatTools.getUpdateUserFilesSql(userId, stateEnum);
    }

    public static String getUpdateUserFilesSql(Object userId, Integer isOpenAccount) {
        OpenAccountStateEnum stateEnum;
        switch (isOpenAccount) {
            case 1: {
                stateEnum = OpenAccountStateEnum.OPEN_ACCOUNT;
                break;
            }
            case 0: {
                stateEnum = OpenAccountStateEnum.NO_ACCOUNT;
                break;
            }
            case 2: {
                stateEnum = OpenAccountStateEnum.READY_ACCOUNT;
                break;
            }
            default: {
                stateEnum = OpenAccountStateEnum.ERROR;
            }
        }
        return CompatTools.getUpdateUserFilesSql(userId, stateEnum);
    }

    public static String getUpdateUserFilesSql(Object userId, OpenAccountStateEnum stateEnum) {
        String type;
        String noSyncValue = "null";
        if (WebMeterInfo.getSaleNameEnum() == SaleVersionEnum.Vue_V3) {
            noSyncValue = "'\u672a\u540c\u6b65'";
        }
        switch (stateEnum) {
            case OPEN_ACCOUNT: {
                type = "f_sendsuccess = '\u6210\u529f',f_sync_sendsuccess = isnull(f_sync_sendsuccess," + noSyncValue + "),f_is_init = isnull(f_is_init," + noSyncValue + ")";
                break;
            }
            case NO_ACCOUNT: {
                type = "f_sendsuccess = " + noSyncValue + ",f_is_init = " + noSyncValue + ",f_sync_sendsuccess = " + noSyncValue;
                break;
            }
            case READY_ACCOUNT: {
                type = "f_sendsuccess = '\u5f85\u6267\u884c',f_sync_sendsuccess = isnull(f_sync_sendsuccess," + noSyncValue + "),f_is_init = isnull(f_is_init," + noSyncValue + ")";
                break;
            }
            default: {
                type = "f_sendsuccess = '\u5931\u8d25',f_sync_sendsuccess = isnull(f_sync_sendsuccess," + noSyncValue + "),f_is_init = isnull(f_is_init," + noSyncValue + ")";
            }
        }
        return CompatTools.getUpdateUserFilesSqlByUpdateColumns(type, userId);
    }

    public static String getUpdateInitUserFilesSql(Object userId, Boolean isInit) {
        return CompatTools.getUpdateUserFilesSql(userId, "f_is_init", isInit);
    }

    public static String getUpdateSyncUserFilesSql(Object userId, Boolean isSync) {
        return CompatTools.getUpdateUserFilesSql(userId, "f_sync_sendsuccess", isSync);
    }

    public static String getUpdateUserFilesSql(Object userId, String columnName, Boolean isOK) {
        String type = isOK != false ? columnName + " = '\u6210\u529f'" : columnName + " = null";
        return CompatTools.getUpdateUserFilesSqlByUpdateColumns(type, userId);
    }

    public static String getUpdateUserFilesSqlByUpdateColumns(String updateColumns, Object userId) {
        String sql;
        String userIdValue = String.valueOf(userId);
        switch (WebMeterInfo.getSaleNameEnum()) {
            case Vue_V1: 
            case Vue_V2: {
                sql = "UPDATE t_userfiles SET " + updateColumns + " WHERE f_user_id = '" + userIdValue + "'";
                break;
            }
            case SILVER_LIGHT: 
            case SILVER_LIGHT2: {
                sql = "UPDATE t_userfiles SET " + updateColumns + " WHERE id = '" + userIdValue + "'";
                break;
            }
            default: {
                sql = "UPDATE t_userfiles SET " + updateColumns + " WHERE f_userfiles_id = '" + userIdValue + "'";
            }
        }
        return WebMeterInfo.DATA_SOURCE_DIALECT.getSql(sql);
    }

    public static String getInstructTableName() {
        switch (WebMeterInfo.getSaleNameEnum()) {
            case SILVER_LIGHT: 
            case SILVER_LIGHT2: {
                return "t_webmeter_instruct";
            }
        }
        return "t_instruct";
    }

    public static String getUserFilesId() {
        switch (WebMeterInfo.getSaleNameEnum()) {
            case Vue_V3: {
                return "f_userfiles_id";
            }
        }
        return "f_user_id";
    }

    public static String getTotalFee() {
        switch (WebMeterInfo.getSaleNameEnum()) {
            case Vue_V1: 
            case Vue_V2: 
            case Vue_V3: {
                return "f_total_fee";
            }
        }
        return "f_meteramountnums";
    }

    public static String getOriginalUserFilesId() {
        switch (WebMeterInfo.getSaleNameEnum()) {
            case Vue_V3: {
                return "f_userfiles_id";
            }
            case Vue_V1: 
            case Vue_V2: {
                return "f_user_id";
            }
        }
        return "id";
    }

    public static String getOriginalUserFilesMeterBase(Boolean withTableName) {
        switch (WebMeterInfo.getSaleNameEnum()) {
            case SILVER_LIGHT: {
                if (withTableName.booleanValue()) {
                    return "t_userfiles.lastinputgasnum";
                }
                return "lastinputgasnum";
            }
            case SILVER_LIGHT2: {
                if (withTableName.booleanValue()) {
                    return "t_userinfo.lastinputgasnum";
                }
                return "lastinputgasnum";
            }
        }
        if (withTableName.booleanValue()) {
            return "t_userfiles.f_meter_base";
        }
        return "f_meter_base";
    }

    public static String getOriginalUserFilesMeterBase() {
        return CompatTools.getOriginalUserFilesMeterBase(true);
    }

    public static JSONObject getMeterInfoCondition(String columns, Object meterNumber, String tableState) {
        JSONObject result = new JSONObject();
        result.put("items", (Object)columns);
        String condition = "t_userfiles.f_meternumber = '" + meterNumber + "' ";
        switch (WebMeterInfo.getSaleNameEnum()) {
            case SILVER_LIGHT: {
                result.put("tableName", (Object)"t_userfiles");
                if (tableState != null) {
                    condition = condition + "and t_userfiles.f_userstate = '" + tableState + "'";
                }
                result.put("condition", (Object)condition);
                break;
            }
            case SILVER_LIGHT2: {
                result.put("tableName", (Object)"t_userfiles,t_userinfo");
                if (tableState != null) {
                    condition = condition + "and t_userinfo.f_userstate = '" + tableState + "' and t_userfiles.f_userstate = '" + tableState + "' ";
                }
                condition = condition + "and t_userfiles.f_userinfoid = t_userinfo.f_userid";
                result.put("condition", (Object)condition);
                break;
            }
            default: {
                result.put("tableName", (Object)"t_userfiles");
                if (tableState != null) {
                    condition = condition + "and t_userfiles.f_table_state = '" + tableState + "'";
                }
                result.put("condition", (Object)condition);
            }
        }
        return result;
    }

    public static JSONObject getMeterInfoCondition(Object meterNumber, String tableState) {
        String columns = String.format("t_userfiles.f_meternumber,t_userfiles.%s userid", CompatTools.getOriginalUserFilesId());
        return CompatTools.getMeterInfoCondition(columns, meterNumber, tableState);
    }

    public static JSONObject getMeterInfoCondition(Object meterNumber) {
        return CompatTools.getMeterInfoCondition(meterNumber, "\u6b63\u5e38");
    }

    public static JSONObject getMeterInfoCondition2(String columns, Object userId) {
        JSONObject result = new JSONObject();
        result.put("items", (Object)columns);
        result.put("tableName", (Object)"t_userfiles");
        result.put("condition", (Object)("t_userfiles." + CompatTools.getOriginalUserFilesId() + " = '" + userId + "'"));
        return result;
    }

    public static JSONObject getMeterInfoCondition2(Object userId) {
        String columns = String.format("t_userfiles.f_meternumber,t_userfiles.%s userid", CompatTools.getOriginalUserFilesId());
        return CompatTools.getMeterInfoCondition2(columns, userId);
    }

    public static String getOrganColumnName() {
        switch (WebMeterInfo.getSaleNameEnum()) {
            case Vue_V1: 
            case Vue_V2: {
                return "f_filialeids";
            }
            case Vue_V3: {
                return "f_filialeid";
            }
        }
        return null;
    }

    public static String getResName(String resName, Integer baseType) {
        if (baseType == 0) {
            switch (WebMeterInfo.getSaleNameEnum()) {
                case SILVER_LIGHT: 
                case SILVER_LIGHT2: {
                    return resName + "SL";
                }
            }
            return resName + "Vue";
        }
        if (baseType == -1) {
            switch (WebMeterInfo.getSaleNameEnum()) {
                case SILVER_LIGHT: {
                    return resName + "SL1";
                }
                case SILVER_LIGHT2: {
                    return resName + "SL2";
                }
                case Vue_V1: {
                    return resName + "V1";
                }
                case Vue_V2: {
                    return resName + "V2";
                }
                case Vue_V3: {
                    return resName + "V3";
                }
            }
            return null;
        }
        if (baseType == 1) {
            switch (WebMeterInfo.getSaleNameEnum()) {
                case SILVER_LIGHT: 
                case SILVER_LIGHT2: {
                    return "yinGuang" + resName.substring(0, 1).toUpperCase() + resName.substring(1);
                }
            }
            return resName;
        }
        return resName;
    }

    public static String getResName(String resName) {
        return CompatTools.getResName(resName, -1);
    }

    public static String getDataSourceResName(String resName) {
        switch (WebMeterInfo.getDataSourceTypeEnum()) {
            case SQLSERVER: {
                return resName;
            }
            case ORACLE: {
                return resName + "_oracle";
            }
            case MYSQL: {
                return resName + "_mysql";
            }
        }
        return null;
    }
}

