package com.aote.webmeter.common.template.saveInstruct;

import com.aote.util.JsonHelper;
import com.aote.webmeter.common.basic.manage.InstructManage;
import com.aote.webmeter.common.dao.ChangeMeterDataDao;
import com.aote.webmeter.common.dao.SaleDataDao;
import com.aote.webmeter.common.dao.UserFilesDao;
import com.aote.webmeter.common.dto.GetChangeMeterDataDto;
import com.aote.webmeter.common.stereotype.Template;
import com.aote.webmeter.common.template.AbstractTemplateBuilder;
import com.aote.webmeter.common.template.pour.SaveTemplatePour;
import com.aote.webmeter.enums.business.InstructInputtorEnum;
import com.aote.webmeter.enums.business.InstructTypeEnum;
import com.aote.webmeter.enums.business.OpenAccountStateEnum;
import com.aote.webmeter.tools.SpringBeanUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 保存换表/注销指令模板
 * @author Mr.river
 */
@Template
public class SaveChangeMeterInstructTemplate extends BasicSaveInstructTemplate {
    private static final Logger LOGGER = LoggerFactory.getLogger(SaveChangeMeterInstructTemplate.class);

    /**
     * 查询待注销/换表的档案数据-Result
     */
    private GetChangeMeterDataDto dto;
    /**
     * 调用保存指令模板时注入业务
     */
    private SaveTemplatePour saveTemplatePour;


    protected SaveChangeMeterInstructTemplate(InstructManage instructManage, UserFilesDao userFilesDao, SaleDataDao saleDataDao, ChangeMeterDataDao changeMeterDataDao){
        super(instructManage,userFilesDao,saleDataDao,changeMeterDataDao);
    }


    public static class Builder extends AbstractTemplateBuilder {
        private final SaveChangeMeterInstructTemplate template;

        public Builder(GetChangeMeterDataDto dto, SaveTemplatePour saveTemplatePour) {
            template = SpringBeanUtil.getBean(SaveChangeMeterInstructTemplate.class);
            template.dto = dto;
            template.saveTemplatePour = saveTemplatePour;
        }

        @Override
        public SaveChangeMeterInstructTemplate build() {
            return template;
        }

        public Builder moduleName(String moduleName){
            template.moduleName = moduleName;
            return this;
        }
    }

    @Override
    protected void beforeExec() {
        super.userId = dto.getF_userfiles_id_old();
        super.type = InstructTypeEnum.ChangeMeter;
        super.content = JsonHelper.toJSON(saveTemplatePour.run(dto));
        super.inputtor = InstructInputtorEnum.SYSTEM_FILES_LIFE_CYCLE;
        super.title = "换表/注销";
    }

    @Override
    protected void afterExec() {
        //更新表具开户状态
        userFilesDao.updateMeterOpenAccountState(dto.getF_userfiles_id_old(), OpenAccountStateEnum.READY_ACCOUNT);
        //更新换表记录状态
        changeMeterDataDao.updateChangeMeterSyncState(dto.getId());
    }
}
