package com.aote.webmeter.common.modules;

import com.aote.webmeter.common.template.pour.SaveTemplatePour;
import com.aote.webmeter.enums.BusinessExceptionCodeEnum;
import com.aote.webmeter.exception.WebmeterException;

/**
 * 抽象物联网表
 *
 * @author Mr.river
 */
public interface AbstractSaveInstruct {
    /**
     * 保存开户指令
     * @return 调用保存指令模板时注入业务
     */
    SaveTemplatePour saveOpenAccount();
    /**
     * 保存换表/注销指令
     * @return 调用保存指令模板时注入业务
     */
    SaveTemplatePour saveChangeMeter();
    /**
     * 保存充值指令
     * @return 调用保存指令模板时注入业务
     */
    default SaveTemplatePour saveGasRecharge(){
        throw new WebmeterException(BusinessExceptionCodeEnum.NO_IMPL_METHOD_BY_INSTRUCT);
    }
    /**
     * 保存调价指令
     * @return 调用保存指令模板时注入业务
     */
    default SaveTemplatePour saveSetPrice(){
        throw new WebmeterException(BusinessExceptionCodeEnum.NO_IMPL_METHOD_BY_INSTRUCT);
    }
}
