package com.aote.webmeter.common.dao;

import com.aote.sql.SqlServer;
import com.aote.webmeter.tools.CompatTools;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

/**
 * 收费数据-数据库操作
 *
 * @author Mr.river
 */
@Transactional(rollbackFor=Exception.class)
@Component
public class SaleDataDao extends AbstractDao {
    private final SqlServer sqlServer;

    public SaleDataDao(SqlServer sqlServer) {
        this.sqlServer = sqlServer;
    }

    /**
     * 更新充值记录的同步状态
     * @param id 充值记录ID
     */
    public void updateSellingGasSyncState(String id){
        sqlServer.run(CompatTools.getUpdateChargeMeterSql(id));
    }

    /**
     * 更新冲正记录的同步状态
     * @param id 充值记录ID
     */
    public void updateCancelSellingGasSyncState(String id){
        sqlServer.run(CompatTools.getUpdateCancelChargeMeterSql(id));
    }

    /**
     * 更新补扣费记录的同步状态
     * @param id 充值记录ID
     */
    public void updateAdjustMoneySyncState(String id){
        sqlServer.run(CompatTools.getUpdateAdjustMoneyMeterSql(id));
    }

    /**
     * 更新补气记录的同步状态
     * @param id 补气记录ID
     */
    public void updateSupplyGasSyncState(String id){
        sqlServer.run(CompatTools.getUpdateSupplyGasMeterSql(id));
    }
}
