package com.aote.webmeter.common.basic.manage.param.instructmanage;

import com.aote.webmeter.common.basic.manage.param.AbstractParam;
import com.aote.webmeter.common.basic.manage.param.AbstractParamBuilder;
import com.aote.webmeter.common.utils.NecessaryValue;
import com.aote.webmeter.common.utils.Condition;
import com.aote.webmeter.enums.business.InstructStateEnum;
import lombok.Getter;

import javax.validation.constraints.NotNull;
import java.util.Optional;

/**
 * 设置指令状态参数器
 * @author Mr.river
 */
@Getter
public class SetInstructStateParam extends AbstractParam {

    /**
     * 指令ID
     */
    private NecessaryValue<String, Condition> id;
    /**
     * 指令标识
     */
    private NecessaryValue<String, Condition> commandId;
    /**
     * 条件表达式
     */
    private NecessaryValue<Condition, Condition> condition;
    /**
     * 指令状态
     */
    private InstructStateEnum state;
    /**
     * 指令元数据
     */
    private String metaData;
    /**
     * 指令响应信息
     */
    private String receiveMsg;
    /**
     * 需要保存的指令标识
     */
    private String syncCommandId;

    private SetInstructStateParam(){

    }

    public static class Builder extends AbstractParamBuilder {
        private final SetInstructStateParam param;

        public Builder(@NotNull InstructStateEnum stateEnum) {
            param = new SetInstructStateParam();
            param.state = stateEnum;
        }

        @Override
        public SetInstructStateParam build() {
            param.condition = checkAndGetNecessaryParams(this.param);
            param.receiveMsg = Optional.ofNullable(param.receiveMsg).orElseGet(()->param.state.getReceiveMsg());
            param.metaData = Optional.ofNullable(param.metaData).orElse(Condition.SQL_GRAMMAR_TAG + "isnull(f_instruct_meta_data,f_instruct_content)");
            param.syncCommandId = Optional.ofNullable(param.syncCommandId).orElse(Condition.SQL_GRAMMAR_TAG + "isnull(f_commandId,id)");
            return param;
        }

        public Builder id(String id){
            param.id = new NecessaryValue<>(1, id, () -> Condition.build().eq("id", id));
            return this;
        }

        public Builder commandId(String commandId){
            param.commandId = new NecessaryValue<>(2, commandId, () -> Condition.build().eq("f_commandId", commandId));
            return this;
        }

        public Builder condition(Condition condition){
            param.condition = new NecessaryValue<>(3, condition);
            return this;
        }

        public Builder metaData(String metaData){
            param.metaData = metaData;
            return this;
        }

        public Builder receiveMsg(String receiveMsg){
            param.receiveMsg = receiveMsg;
            return this;
        }

        public Builder syncCommandId(String syncCommandId){
            param.syncCommandId = syncCommandId;
            return this;
        }
    }

    public Condition getCondition(){
        return this.condition.getOutValue();
    }
}
