package com.aote.webmeter.common.basic.manage.param.instructmanage;

import com.aote.webmeter.common.basic.manage.param.AbstractParam;
import com.aote.webmeter.common.basic.manage.param.AbstractParamBuilder;
import com.aote.webmeter.common.utils.NecessaryValue;
import com.aote.webmeter.common.utils.Condition;
import com.aote.webmeter.tools.StandardCompatTools;
import lombok.Getter;

import javax.validation.constraints.NotNull;

/**
 * 获取待执行指令参数器
 * @author Mr.river
 */
@Getter
public class GetWaitInstructParam extends AbstractParam {

    /**
     * 表档案ID
     */
    private NecessaryValue<String, Condition> userId;
    /**
     * 条件表达式
     */
    private NecessaryValue<Condition, Condition> condition;

    private GetWaitInstructParam(){

    }

    public static class Builder extends AbstractParamBuilder {
        private final GetWaitInstructParam param;

        public Builder() {
            param = new GetWaitInstructParam();
        }

        /**
         * 通过执行指令参数器构造
         * @param runInstructParam 执行指令参数器
         * @return 获取待执行指令参数器
         */
        public GetWaitInstructParam build(@NotNull RunInstructParam runInstructParam) {
            condition(runInstructParam.getCondition());
            return param;
        }

        /**
         * 初始化执行指令参数器
         * @return 获取待执行指令参数器
         */
        @Override
        public GetWaitInstructParam build() {
            param.condition = checkAndGetNecessaryParams(this.param);
            return param;
        }

        public Builder userId(String userId){
            param.userId = new NecessaryValue<>(1, userId, () -> StandardCompatTools.getBasicCondition(userId));
            return this;
        }

        public Builder condition(Condition condition){
            param.condition = new NecessaryValue<>(3, condition);
            return this;
        }
    }

    public Condition getCondition(){
        return this.condition.getOutValue();
    }
}
