/*
 * Decompiled with CFR 0.152.
 */
package com.aote.webmeter.tools.iot.onenet;

import com.af.plugins.HttpAsyncConnectionPoolUtil;
import com.af.plugins.HttpConnectionPoolUtil;
import com.af.plugins.RestTools;
import com.aote.webmeter.enums.OnenetApiEnum;
import com.aote.webmeter.enums.WebmeterPropertiesIOTEnum;
import com.aote.webmeter.tools.WebMeterInfo;
import com.aote.webmeter.tools.iot.onenet.OnenetRestTools;
import com.aote.webmeter.tools.iot.onenet.getMQTTToken;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.log4j.Logger;
import org.json.JSONObject;

public class OnenetMQTTRestTools {
    private static final Logger LOGGER = Logger.getLogger(OnenetRestTools.class);

    public static JSONObject createDevice(JSONObject params, String key) {
        String path = OnenetApiEnum.MQTTRegister_URL.getValue();
        JSONObject headers = OnenetMQTTRestTools.getHeader(key);
        JSONObject result = new JSONObject(HttpConnectionPoolUtil.request((String)path, (String)params.toString(), (String)headers.toString(), (HttpRequestBase)new HttpPost()));
        return result;
    }

    public static JSONObject deleteDevice(String deviceId, String key) {
        String path = OnenetApiEnum.DEVICE_URL.getValue() + "/" + deviceId;
        JSONObject headers = OnenetMQTTRestTools.getHeader(key);
        JSONObject result = new JSONObject(RestTools.delete((String)path, null, (JSONObject)headers));
        return result;
    }

    public static JSONObject writeDeviceRes(String deviceId, String timeout, JSONObject content, String key) {
        JSONObject params = new JSONObject();
        params.put("device_id", (Object)deviceId);
        params.put("timeout", (Object)"86400");
        String path = RestTools.formatURL((String)OnenetApiEnum.MQTTCOMMAND_URL.getValue(), (JSONObject)params);
        JSONObject headers = new JSONObject();
        headers.put("api-key", (Object)WebMeterInfo.getString(WebmeterPropertiesIOTEnum.ONE_NET_APIKEY));
        LOGGER.debug((Object)("\u8bf7\u6c42\u7684\u5730\u5740\uff1a" + path));
        LOGGER.debug((Object)("\u8bf7\u6c42\u5934\uff1a" + headers));
        LOGGER.debug((Object)("\u8bf7\u6c42\u4f53\uff1a" + content));
        HttpAsyncConnectionPoolUtil.request((String)path, (String)content.toString(), (String)headers.toString(), (HttpRequestBase)new HttpPost());
        return new JSONObject().put("errno", 0);
    }

    public static JSONObject writeDeviceRes2(String imei, JSONObject content) {
        JSONObject params = new JSONObject();
        params.put("topic", (Object)("hskj/hscq/" + imei));
        String path = RestTools.formatURL((String)OnenetApiEnum.MQTTCOMMAND_URL2.getValue(), (JSONObject)params);
        JSONObject headers = new JSONObject();
        headers.put("api-key", (Object)WebMeterInfo.getString(WebmeterPropertiesIOTEnum.ONE_NET_APIKEY));
        LOGGER.debug((Object)("\u8bf7\u6c42\u7684\u5730\u5740\uff1a" + path));
        LOGGER.debug((Object)("\u8bf7\u6c42\u5934\uff1a" + headers));
        LOGGER.debug((Object)("\u8bf7\u6c42\u4f53\uff1a" + content));
        HttpAsyncConnectionPoolUtil.request((String)path, (String)content.toString(), (String)headers.toString(), (HttpRequestBase)new HttpPost());
        return new JSONObject().put("errno", 0);
    }

    private static JSONObject getHeader(String key) throws Exception {
        JSONObject headers = new JSONObject();
        headers.put("Authorization", (Object)getMQTTToken.assembleToken(key));
        return headers;
    }
}

