/*
 * Decompiled with CFR 0.152.
 */
package com.aote.webmeter.tools.iot;

import com.af.plugins.HttpDeleteWithBody;
import com.aote.webmeter.enums.IOTBusinessTypeEnum;
import com.aote.webmeter.enums.NotifyTypeEnum;
import com.aote.webmeter.enums.WebmeterPropertiesIOTEnum;
import com.aote.webmeter.tools.WebMeterInfo;
import com.aote.webmeter.tools.iot.IotCommonTools;
import com.aote.webmeter.tools.iot.aep.AEPTools;
import java.io.IOException;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpPost;
import org.apache.log4j.Logger;
import org.json.JSONObject;

public class SignalDeliveryTools {
    private static final Logger LOGGER = Logger.getLogger(SignalDeliveryTools.class);

    public static JSONObject myPostCommand(String serviceId, String method, String deviceId, JSONObject jo, Integer expireTime) throws IOException {
        int isAep = IotCommonTools.getIsAep();
        String callbackUrl = isAep == 1 ? WebMeterInfo.getString(WebmeterPropertiesIOTEnum.AEP_CALLBACK_URL) : (isAep == 0 ? WebMeterInfo.getString(WebmeterPropertiesIOTEnum.OC_CALLBACK_URL) : WebMeterInfo.getString(WebmeterPropertiesIOTEnum.OC2_CALLBACK_URL));
        Integer maxRetransmit = 3;
        JSONObject paramCommand = new JSONObject();
        paramCommand.put("serviceId", (Object)serviceId);
        paramCommand.put("method", (Object)method);
        paramCommand.put("paras", (Object)jo);
        if (expireTime == null) {
            expireTime = 0;
        }
        JSONObject content = new JSONObject();
        content.put("deviceId", (Object)deviceId);
        content.put("command", (Object)paramCommand);
        content.put("callbackUrl", (Object)callbackUrl);
        content.put("expireTime", (Object)expireTime);
        content.put("maxRetransmit", (Object)maxRetransmit);
        JSONObject result = IotCommonTools.post(IOTBusinessTypeEnum.SEND_COMMAND, (HttpEntityEnclosingRequestBase)new HttpPost(), content, null);
        if (result.has("errorEntity")) {
            throw new RuntimeException(result.toString());
        }
        return new JSONObject().put("commandId", result.get("commandId"));
    }

    public static JSONObject myPostCommand(String serviceId, String method, String deviceId, JSONObject jo) throws Exception {
        String hasProfile = WebMeterInfo.getString("hasProfile");
        if (hasProfile != null && hasProfile.equals("1")) {
            return AEPTools.getRetProfile(deviceId, jo, method, serviceId);
        }
        return SignalDeliveryTools.myPostCommand(serviceId, method, deviceId, jo, (Integer)0);
    }

    public static JSONObject myPostCommand(String deviceId, String base64String) throws Exception {
        return AEPTools.getRet(deviceId, base64String);
    }

    public static JSONObject myPostCommand(JSONObject count) throws Exception {
        String hasProfile = WebMeterInfo.getString("hasProfile");
        if (hasProfile != null && hasProfile.equals("1")) {
            return AEPTools.getRetProfile(count);
        }
        return AEPTools.getRet(count);
    }

    public static JSONObject myPostCommand(String method, String deviceId, String base64String) throws IOException {
        return SignalDeliveryTools.myPostCommand(method, deviceId, base64String, 0);
    }

    public static JSONObject myPostCommand(String method, String deviceId, String base64String, Integer expireTime) throws IOException {
        JSONObject object = new JSONObject();
        object.put("rawData", (Object)base64String);
        return SignalDeliveryTools.myPostCommand("RawData", method, deviceId, object, expireTime);
    }

    public static JSONObject myPostCommand(String serviceId, String method, String deviceId, String base64String) throws Exception {
        String hasProfile = WebMeterInfo.getString("hasProfile");
        if (hasProfile != null && hasProfile.equals("1")) {
            return AEPTools.getRetProfile(deviceId, base64String, method, serviceId);
        }
        return SignalDeliveryTools.myPostCommand(serviceId, method, deviceId, base64String, (Integer)0);
    }

    public static JSONObject myPostCommand(String serviceId, String method, String deviceId, String base64String, Integer expireTime) throws IOException {
        JSONObject object = new JSONObject();
        object.put("rawData", (Object)base64String);
        String serviceIdValue = IotCommonTools.getIsAep() == 1 ? serviceId : "RawData";
        return SignalDeliveryTools.myPostCommand(serviceIdValue, method, deviceId, object, expireTime);
    }

    public static JSONObject subscribe(NotifyTypeEnum notifyTypeEnum, String callBackUrl) throws IOException {
        JSONObject content = new JSONObject();
        content.put("notifyType", (Object)notifyTypeEnum.getValue());
        content.put("callbackUrl", (Object)callBackUrl);
        JSONObject result = IotCommonTools.post(IOTBusinessTypeEnum.SUBSCRIPTIONS, (HttpEntityEnclosingRequestBase)new HttpPost(), content, null);
        if (result.has("errorEntity")) {
            LOGGER.error((Object)("IOT\u63a5\u53e3\u8c03\u7528\u9519\u8bef\uff01\uff0c\u4fe1\u606f\uff1a" + result));
            return null;
        }
        return result;
    }

    public static JSONObject deleteAllSubscribe() throws IOException {
        JSONObject result = IotCommonTools.post(IOTBusinessTypeEnum.SUBSCRIPTIONS, (HttpEntityEnclosingRequestBase)new HttpDeleteWithBody(), null, null);
        if (result.has("errorEntity")) {
            LOGGER.error((Object)("IOT\u63a5\u53e3\u8c03\u7528\u9519\u8bef\uff01\uff0c\u4fe1\u606f\uff1a" + result));
            return null;
        }
        return result;
    }
}

