/*
 * Decompiled with CFR 0.152.
 */
package com.aote.webmeter.tools;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;

public class EncodingUtil {
    public static String reverseHexStringByEndian(String hexString, Endian endian) {
        char[] reversedChars;
        block4: {
            char[] chars;
            int length;
            block3: {
                if (hexString == null || hexString.length() % 2 != 0) {
                    throw new IllegalArgumentException("\u8f93\u5165\u7684\u5b57\u7b26\u4e32\u5fc5\u987b\u662f\u6709\u6548\u7684\u5341\u516d\u8fdb\u5236\u5b57\u7b26\u4e32");
                }
                length = hexString.length();
                chars = hexString.toCharArray();
                reversedChars = new char[length];
                if (endian != Endian.BIG_ENDIAN) break block3;
                for (int i = 0; i < length; i += 2) {
                    reversedChars[i] = chars[i];
                    reversedChars[i + 1] = chars[i + 1];
                }
                break block4;
            }
            if (endian != Endian.LITTLE_ENDIAN) break block4;
            for (int i = 0; i < length; i += 2) {
                reversedChars[i] = chars[length - i - 2];
                reversedChars[i + 1] = chars[length - i - 1];
            }
        }
        return new String(reversedChars);
    }

    public static String calculateCRC16(String hexInput, Boolean isLE) {
        return EncodingUtil.byteArrayToHexString(EncodingUtil.calculateCRC16Modbus(EncodingUtil.hexStringToByteArray(hexInput), isLE));
    }

    public static byte[] calculateCRC16Modbus(byte[] inputBytes, Boolean isLE) {
        int crc = 65535;
        int polynomial = 40961;
        for (byte b : inputBytes) {
            crc ^= b & 0xFF;
            for (int i = 0; i < 8; ++i) {
                boolean bit = (crc & 1) == 1;
                crc >>= 1;
                if (!bit) continue;
                crc ^= polynomial;
            }
        }
        byte[] crcBytes = new byte[2];
        if (isLE.booleanValue()) {
            crcBytes[0] = (byte)(crc & 0xFF);
            crcBytes[1] = (byte)(crc >> 8 & 0xFF);
        } else {
            crcBytes[1] = (byte)(crc & 0xFF);
            crcBytes[0] = (byte)(crc >> 8 & 0xFF);
        }
        return crcBytes;
    }

    public static List<Integer> findCharPositions(String str, char ch) {
        ArrayList<Integer> positions = new ArrayList<Integer>();
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) != ch) continue;
            positions.add(i);
        }
        return positions;
    }

    public static String padLeft(String input, int length, char paddingChar, boolean checkLength) throws Exception {
        if (input.length() > length && checkLength) {
            throw new Exception("\u53c2\u6570\u957f\u5ea6\u8d85\u957f:" + input);
        }
        return StringUtils.repeat((char)paddingChar, (int)(length - input.length())) + input;
    }

    public static String padRight(String input, int length, char paddingChar, boolean checkLength) throws Exception {
        if (input.length() > length && checkLength) {
            throw new Exception("\u53c2\u6570\u957f\u5ea6\u8d85\u957f:" + input);
        }
        return input + StringUtils.repeat((char)paddingChar, (int)(length - input.length()));
    }

    public static String padToMultipleWithDirection(String input, int step, char paddingChar, boolean padLeft) {
        int length = input.length();
        int remainder = length % step;
        if (remainder == 0) {
            return input;
        }
        int paddingLength = step - remainder;
        StringBuilder paddedString = new StringBuilder(input);
        for (int i = 0; i < paddingLength; ++i) {
            if (padLeft) {
                paddedString.insert(0, paddingChar);
                continue;
            }
            paddedString.append(paddingChar);
        }
        return paddedString.toString();
    }

    public static byte[] hexStringToByteArray(String hexString) {
        if ((hexString = hexString.replaceAll("[^0-9A-Fa-f]", "")).length() % 2 != 0) {
            hexString = "0" + hexString;
        }
        int len = hexString.length() / 2;
        byte[] byteArray = new byte[len];
        for (int i = 0; i < len; ++i) {
            int startIndex = i * 2;
            int endIndex = startIndex + 2;
            String hex = hexString.substring(startIndex, endIndex);
            byteArray[i] = (byte)Integer.parseInt(hex, 16);
        }
        return byteArray;
    }

    public static String byteArrayToHexString(byte[] byteArray) {
        StringBuilder hexString = new StringBuilder(2 * byteArray.length);
        for (byte b : byteArray) {
            hexString.append(String.format("%02X", b));
        }
        return hexString.toString();
    }

    public static String binaryToHexWithCorrectByteOrder(String binaryString) {
        binaryString = binaryString.replaceAll("[^01]", "");
        binaryString = EncodingUtil.padToMultipleWithDirection(binaryString, 8, '0', false);
        StringBuilder hexString = new StringBuilder(binaryString.length() / 8);
        for (int i = 0; i < binaryString.length(); i += 8) {
            String binaryByte = binaryString.substring(i, i + 8);
            String reversedBinaryByte = EncodingUtil.reverseBinaryString(binaryByte);
            int decimalValue = Integer.parseInt(reversedBinaryByte, 2);
            String hexByte = String.format("%02X", decimalValue);
            hexString.append(hexByte);
        }
        return hexString.toString();
    }

    public static String reverseBinaryString(String binaryString) {
        StringBuilder reversedString = new StringBuilder(binaryString.length());
        for (int i = binaryString.length() - 1; i >= 0; --i) {
            reversedString.append(binaryString.charAt(i));
        }
        return reversedString.toString();
    }

    public static String hexToBinaryWithReversedBits(String hexString) throws Exception {
        byte[] byteArray = EncodingUtil.hexStringToByteArray(hexString);
        StringBuilder binaryString = new StringBuilder(byteArray.length * 8);
        for (byte b : byteArray) {
            String binaryByte = Integer.toBinaryString(b & 0xFF);
            binaryByte = EncodingUtil.padLeft(binaryByte, 8, '0', false);
            String reversedBinaryByte = EncodingUtil.reverseBinaryString(binaryByte);
            binaryString.append(reversedBinaryByte);
        }
        return binaryString.toString();
    }

    public static String hexToBinary(String hexString) {
        StringBuilder binaryStringBuilder = new StringBuilder();
        for (int i = 0; i < hexString.length(); ++i) {
            char hexChar = hexString.charAt(i);
            StringBuilder binary = new StringBuilder(Integer.toBinaryString(Integer.parseInt(String.valueOf(hexChar), 16)));
            while (binary.length() < 4) {
                binary.insert(0, "0");
            }
            binaryStringBuilder.append((CharSequence)binary);
        }
        return binaryStringBuilder.toString();
    }

    public static String binaryToHex(String binaryString) {
        int padding_ = binaryString.length() % 8;
        int padding = 8 - (padding_ == 0 ? 8 : padding_);
        StringBuilder paddedBinary = new StringBuilder();
        for (int i = 0; i < padding; ++i) {
            paddedBinary.append('0');
        }
        paddedBinary.append(binaryString);
        StringBuilder hexString = new StringBuilder();
        for (int i = 0; i < paddedBinary.length(); i += 4) {
            String binaryChunk = paddedBinary.substring(i, i + 4);
            int decimal = Integer.parseInt(binaryChunk, 2);
            hexString.append(Integer.toHexString(decimal));
        }
        return hexString.toString();
    }

    public static void mergeJSONObjects(JSONObject json1, JSONObject json2) {
        Iterator keys2 = json2.keys();
        while (keys2.hasNext()) {
            String key = (String)keys2.next();
            json1.put(key, json2.get(key));
        }
    }

    public static enum Endian {
        BIG_ENDIAN,
        LITTLE_ENDIAN;

    }
}

