/*
 * Decompiled with CFR 0.152.
 */
package com.aote.webmeter.socket.core.channel;

import com.af.plugins.ConvertTools;
import com.aote.logic.LogicServer;
import com.aote.webmeter.socket.SocketServerManager;
import com.aote.webmeter.socket.config.SocketConfigItem;
import com.aote.webmeter.socket.core.channel.ChannelData;
import com.aote.webmeter.socket.core.client.ClientManager;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.net.InetSocketAddress;
import java.util.Arrays;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractChannelHandler<T>
extends SimpleChannelInboundHandler<T> {
    private final Logger LOGGER = LoggerFactory.getLogger(AbstractChannelHandler.class);

    protected final void channelRead0(ChannelHandlerContext ctx, T msg) {
        Channel channel = ctx.channel();
        this.LOGGER.debug("channelId:{}, \u6536\u5230\u6d88\u606f", (Object)channel.id().asLongText());
        String channelId = channel.id().asLongText();
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug("channelId:{}, \u6536\u5230\u6d88\u606f", (Object)channelId);
        }
        ClientManager.setChannelId(channelId);
        if (ClientManager.getChannelData() == null) {
            this.initChannelData(ctx);
        }
        this.read(ctx, msg);
    }

    protected abstract void read(ChannelHandlerContext var1, T var2);

    private void initChannelData(ChannelHandlerContext ctx) {
        Channel channel = ctx.channel();
        String port = String.valueOf(((InetSocketAddress)channel.localAddress()).getPort());
        SocketConfigItem configItem = SocketServerManager.getSocketConfigItemByPort(port);
        ClientManager.add(channel.id().asLongText(), new ChannelData(configItem, channel, new JSONObject()));
    }

    protected String runBusiness(ByteBuf content, String remoteAddress) {
        String realData;
        SocketConfigItem configItem = ClientManager.getConfig();
        byte[] data = new byte[content.readableBytes()];
        content.readBytes(data);
        this.LOGGER.debug("\u6570\u636e\u539f\u59cb\u4f53\uff1a{}", (Object)Arrays.toString(data));
        try {
            switch (configItem.getDecodeType()) {
                case HEX: {
                    realData = ConvertTools.byteToHexStr((byte[])data);
                    break;
                }
                default: {
                    realData = ConvertTools.bytesToStr((byte[])data);
                    break;
                }
            }
        }
        catch (Exception e) {
            this.LOGGER.error("\u6570\u636e\u89e3\u6790\u5931\u8d25\uff1a", (Throwable)e);
            return "6f6b";
        }
        this.LOGGER.debug("\u670d\u52a1\u7aef\u6536\u5230\u4fe1\u606f\uff1a{}", (Object)realData);
        LogicServer logicServer = (LogicServer)SocketServerManager.applicationContext.getBean(LogicServer.class);
        try {
            JSONObject params = new JSONObject();
            params.put("value", (Object)realData);
            params.put("address", (Object)remoteAddress);
            return logicServer.run(configItem.getLogicName(), params).toString();
        }
        catch (Exception e) {
            this.LOGGER.error("\u4e1a\u52a1\u5904\u7406\u5931\u8d25", (Throwable)e);
            throw e;
        }
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        String channelId = ctx.channel().id().asLongText();
        String address = ctx.channel().remoteAddress().toString();
        this.LOGGER.debug("channelId:{}, address:{}, \u6210\u529f\u5efa\u7acb\u8fde\u63a5", (Object)channelId, (Object)address);
        super.channelActive(ctx);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        try {
            ctx.close();
            ClientManager.remove();
        }
        catch (Exception e) {
            this.LOGGER.error("\u5173\u95ed\u901a\u9053\u65f6\u53d1\u751f\u5f02\u5e38", (Throwable)e);
        }
        super.channelInactive(ctx);
    }
}

