/*
 * Decompiled with CFR 0.152.
 */
package com.aote.webmeter.common.basic.manage;

import com.af.plugins.CommonTools;
import com.af.plugins.DateTools;
import com.af.plugins.JsonTools;
import com.aote.entity.EntityServer;
import com.aote.logic.LogicServer;
import com.aote.sql.SqlServer;
import com.aote.webmeter.enums.DataSourceTypeEnum;
import com.aote.webmeter.enums.SaleVersionEnum;
import com.aote.webmeter.tools.CompatTools;
import com.aote.webmeter.tools.WebMeterInfo;
import java.math.BigDecimal;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Transactional(rollbackFor={Exception.class})
@Component
public class SettlementManage {
    private static final Logger LOGGER = LoggerFactory.getLogger(SettlementManage.class);
    @Autowired
    private EntityServer entityServer;
    @Autowired
    private LogicServer logicServer;
    @Autowired
    private SqlServer sqlServer;

    public JSONObject settlement(JSONObject params) throws Exception {
        double useGas;
        String address;
        String gasProperties;
        String userType;
        String queryUserItems;
        JSONObject result = new JSONObject();
        boolean isFirstIgnore = params.optBoolean("isFirstIgnore", false);
        boolean enableDaySettlement = params.optBoolean("enableDaySettlement", false);
        boolean disSaveSell = params.optBoolean("disSaveSell", false);
        SaleVersionEnum saleVersion = WebMeterInfo.getSaleNameEnum();
        String userId = String.valueOf(params.get("userId"));
        String condition = CompatTools.getBasicCondition(userId);
        JSONObject userFiles = this.sqlServer.query("webmeterGetBaseData", new JSONObject().put("items", (Object)"*").put("tableName", (Object)"t_userfiles").put("condition", (Object)condition)).getJSONObject(0);
        String meterNumber = String.valueOf(userFiles.get("f_meternumber"));
        String userInfoId = String.valueOf(userFiles.get("f_userinfo_id"));
        switch (saleVersion) {
            case Vue_V3: 
            case Vue_V2: {
                queryUserItems = "f_user_name,f_userinfo_code,f_people_num";
                break;
            }
            default: {
                queryUserItems = "version,f_balance,f_user_type,f_gasproperties,f_user_name,f_userinfo_code,f_people_num,f_price_id,f_address";
            }
        }
        JSONObject userInfo = this.sqlServer.query("webmeterGetBaseData", new JSONObject().put("items", (Object)queryUserItems).put("tableName", (Object)"t_userinfo").put("condition", (Object)("f_userinfo_id = '" + userInfoId + "'"))).getJSONObject(0);
        String gasBrandId = String.valueOf(userFiles.get("f_gasbrand_id"));
        JSONObject gasBrand = this.sqlServer.query("webmeterGetBaseData", new JSONObject().put("items", (Object)"f_meter_brand,f_meter_type").put("tableName", (Object)"t_gasbrand").put("condition", (Object)("id = '" + gasBrandId + "'"))).getJSONObject(0);
        LOGGER.info("\u7ed3\u7b97\u8ffd\u6eaf\uff1a\u8868\u53f7{}\u5f00\u59cb\u8fdb\u884c\u7ed3\u7b97", (Object)meterNumber);
        double meterBalance = params.optDouble("f_meter_balance", 0.0);
        LOGGER.info("\u7ed3\u7b97\u8ffd\u6eaf\uff1a\u8868\u7aef\u6216\u6284\u8868\u7cfb\u7edf\u8fd4\u56de\u7684\u4f59\u989d\uff1a{}", (Object)meterBalance);
        int uploadTimes = userFiles.optInt("f_meteread_number", 0) + 1;
        String handDate = params.getString("f_hand_date");
        int priceId = userFiles.optInt("f_price_id", 0);
        if (priceId == 0) {
            priceId = userInfo.optInt("f_price_id", 0);
        }
        switch (saleVersion) {
            case Vue_V3: 
            case Vue_V2: {
                userType = userFiles.getString("f_user_type");
                gasProperties = userFiles.getString("f_gasproperties");
                if (!userFiles.has("f_useraddress_id")) {
                    address = userInfo.optString("f_address", "\u5730\u5740\u4fe1\u606f\u4e0d\u5b58\u5728");
                    break;
                }
                JSONArray addressList = this.sqlServer.query("webmeterGetBaseData", new JSONObject().put("items", (Object)"f_address").put("tableName", (Object)"t_user_address").put("condition", (Object)("id = '" + userFiles.get("f_useraddress_id") + "'")));
                if (addressList.length() > 0) {
                    address = addressList.getJSONObject(0).optString("f_address", "\u5730\u5740\u4fe1\u606f\u4e3a\u7a7a");
                    break;
                }
                address = "\u5730\u5740\u4fe1\u606f\u4e0d\u5b58\u5728";
                break;
            }
            default: {
                userType = userInfo.getString("f_user_type");
                gasProperties = userInfo.getString("f_gasproperties");
                address = userInfo.getString("f_address");
            }
        }
        double usedGas = params.getDouble("f_tablebase");
        double lastUsedGas = params.optDouble("f_last_tablebase", userFiles.optDouble("f_meter_base", 0.0));
        LOGGER.info("\u7ed3\u7b97\u8ffd\u6eaf\uff1a\u672c\u6b21\u6284\u8868\u5e95\u6570\uff1a{},\u4e0a\u6b21\u6284\u8868\u5e95\u6570\uff1a{}", (Object)usedGas, (Object)lastUsedGas);
        double balanceValue = saleVersion == SaleVersionEnum.Vue_V3 ? userFiles.optDouble("f_balance_amount", 0.0) : userInfo.optDouble("f_balance", 0.0);
        Double realUseGas = null;
        boolean isSaveHandPlan = true;
        if (enableDaySettlement) {
            String beginDay = DateTools.getNow((String)"yyyy-MM-dd 00:00:00");
            boolean isHasToDayHandPlan = userFiles.has("f_meteread_date") ? DateTools.compareDate((String)userFiles.getString("f_meteread_date"), (String)beginDay) : false;
            if (isHasToDayHandPlan || params.optInt("isForceDaySettlement", 0) == 1) {
                LOGGER.info("\u7ed3\u7b97\u8ffd\u6eaf\uff1a\u8fdb\u5165\u65e5\u7ed3\u7b97\u6a21\u5f0f");
                realUseGas = 0.0;
                usedGas = lastUsedGas;
                isSaveHandPlan = false;
            }
        }
        if (isFirstIgnore && userFiles.opt("f_meteread_date") == null) {
            LOGGER.info("\u7ed3\u7b97\u8ffd\u6eaf\uff1a\u8fdb\u5165\u9996\u6b21\u4e0a\u62a5\u5ffd\u7565\u7ed3\u7b97\u6a21\u5f0f");
            realUseGas = 0.0;
            if (params.optBoolean("isCoverLastTableBase", false)) {
                lastUsedGas = usedGas;
            }
        }
        if (realUseGas == null) {
            realUseGas = CommonTools.sub((Object)usedGas, (Object)lastUsedGas).doubleValue();
        }
        if ((useGas = realUseGas.doubleValue()) < 0.0) {
            useGas = 0.0;
        }
        LOGGER.info("\u7ed3\u7b97\u8ffd\u6eaf\uff1a\u5b9e\u9645\u7528\u6c14\u91cf:{},\u8c03\u6574\u8d1f\u6570\u540e\u7684\u7528\u6c14\u91cf:{}", (Object)realUseGas, (Object)useGas);
        JsonTools.addJSON((JSONObject)result, (JSONObject)this.gasFeeCalculate(useGas, priceId, userFiles, userInfo.opt("f_people_num"), handDate));
        LOGGER.info("\u7ed3\u7b97\u8ffd\u6eaf\uff1a\u7ed3\u7b97\u540e\u6c47\u603b\u4fe1\u606f:{}", (Object)result);
        double chargeNum = result.getDouble("chargenum");
        BigDecimal curBalance = CommonTools.sub((Object)balanceValue, (Object)chargeNum);
        LOGGER.info("\u7ed3\u7b97\u8ffd\u6eaf\uff1a\u7ed3\u7b97\u540e\u5269\u4f59\u91d1\u989d:{}", (Object)curBalance);
        double useGasAmount = userFiles.optDouble("f_total_usegas_amount", 0.0);
        if (isSaveHandPlan) {
            String handDateSql;
            String addChargePriceSql;
            String chargeState;
            String meterState;
            if (usedGas < lastUsedGas) {
                meterState = "\u672a\u6284\u8868";
                chargeState = "\u65e0\u6548";
            } else {
                meterState = "\u5df2\u6284\u8868";
                chargeState = "\u6709\u6548";
            }
            JSONObject handPlan = new JSONObject();
            handPlan.put("f_meteread_id", params.opt("f_meteread_id"));
            handPlan.put("f_simplehand_id", params.opt("f_simplehand_id"));
            handPlan.put("f_input_gas", userFiles.opt("f_input_gas"));
            handPlan.put("f_balance_gas", userFiles.opt("f_balance_gas"));
            handPlan.put("f_balance_amount", (Object)curBalance);
            handPlan.put("f_oughtamount", (Object)realUseGas);
            handPlan.put("f_oughtfee", chargeNum);
            handPlan.put("f_balance", balanceValue);
            handPlan.put("f_curbalance", (Object)curBalance);
            handPlan.put("f_tablebase", usedGas);
            handPlan.put("f_last_tablebase", lastUsedGas);
            handPlan.put("f_totaluse_fee", useGasAmount);
            handPlan.put("f_totalcharge_fee", userFiles.opt("f_total_fee"));
            handPlan.put("f_inputtor", (Object)"\u6284\u8868\u7cfb\u7edf");
            handPlan.put("f_whether_pay", (Object)"\u662f");
            handPlan.put("f_hand_date", (Object)handDate);
            handPlan.put("f_input_date", (Object)DateTools.getNow2());
            handPlan.put("f_price_id", priceId);
            handPlan.put("f_stairprice_id", result.get("priceId"));
            handPlan.put("f_user_name", userInfo.opt("f_user_name"));
            handPlan.put("f_user_type", (Object)userType);
            handPlan.put("f_gasproperties", (Object)gasProperties);
            handPlan.put("f_user_type", (Object)userType);
            handPlan.put("f_meter_classify", (Object)"\u7269\u8054\u7f51\u8868");
            handPlan.put("f_userinfo_id", userFiles.opt("f_userinfo_id"));
            handPlan.put("f_userinfo_code", userInfo.opt("f_userinfo_code"));
            handPlan.put("f_address", (Object)address);
            handPlan.put("f_meternumber", userFiles.opt("f_meternumber"));
            handPlan.put("f_meter_state", (Object)meterState);
            handPlan.put("f_accounts_state", (Object)"\u81ea\u52a8\u4e0b\u8d26");
            handPlan.put("f_hand_state", (Object)"\u6709\u6548");
            handPlan.put("f_user_id", userFiles.opt("f_user_id"));
            handPlan.put("f_userfiles_id", userFiles.opt("f_userfiles_id"));
            handPlan.put("f_meter_brand", gasBrand.opt("f_meter_brand"));
            handPlan.put("f_filiale", userFiles.opt("f_filiale"));
            handPlan.put("f_filialeids", userFiles.opt("f_filialeids"));
            handPlan.put("f_outlets", userFiles.opt("f_outlets"));
            handPlan.put("f_orgstr", userFiles.opt("f_orgstr"));
            handPlan.put("f_orgid", userFiles.opt("f_orgid"));
            handPlan.put("f_depid", userFiles.opt("f_depid"));
            handPlan.put("f_orgname", userFiles.opt("f_orgname"));
            handPlan.put("f_depname", userFiles.opt("f_depname"));
            int handPlanId = new JSONObject(this.entityServer.partialSave("t_handplan", handPlan)).getInt("id");
            String chargeType = saleVersion == SaleVersionEnum.Vue_V3 ? "f_type" : "f_charge_type";
            DataSourceTypeEnum dataSource = WebMeterInfo.getDataSourceTypeEnum();
            if (dataSource == DataSourceTypeEnum.ORACLE) {
                addChargePriceSql = "INSERT INTO t_chargeprice(id,f_user_id,f_userfiles_id,f_hand_id,f_price_name,f_price,f_gas,f_money," + chargeType + ",f_state,f_operate_date)\n            values (SEQ_CHARGEPRICE_ID.nextval,";
                handDateSql = "to_date('" + handDate + "','yyyy-MM-dd HH24:mi:ss')";
            } else {
                addChargePriceSql = "INSERT INTO t_chargeprice(f_user_id,f_userfiles_id,f_hand_id,f_price_name,f_price,f_gas,f_money," + chargeType + ",f_state,f_operate_date)\n            values (";
                handDateSql = "'" + handDate + "'";
            }
            result.getJSONArray("chargeprice").forEach(item -> {
                JSONObject itemObject = (JSONObject)item;
                String sql = String.format("%s '%s','%s','%s','%s','%s','%s','%s','\u6284\u8868\u5212\u4ef7','%s',%s)", addChargePriceSql, userFiles.get("f_user_id"), userId, handPlanId, itemObject.get("f_price_name"), itemObject.get("f_price"), itemObject.get("f_gas"), itemObject.get("f_money"), chargeState, handDateSql);
                this.sqlServer.runSQL(sql);
            });
            if (saleVersion == SaleVersionEnum.Vue_V1 && !disSaveSell) {
                JSONObject sellGas = new JSONObject();
                sellGas.put("f_balance", balanceValue);
                sellGas.put("f_curbalance", (Object)curBalance);
                sellGas.put("f_tablebase", usedGas);
                sellGas.put("f_last_tablebase", lastUsedGas);
                sellGas.put("f_meter_type", gasBrand.opt("f_meter_type"));
                sellGas.put("f_preamount", chargeNum);
                sellGas.put("f_pregas", useGas);
                sellGas.put("f_payment", (Object)"\u73b0\u91d1\u7f34\u8d39");
                sellGas.put("f_price_id", priceId);
                sellGas.put("f_stairprice_id", result.get("priceId"));
                sellGas.put("f_user_id", userFiles.opt("f_user_id"));
                sellGas.put("f_userfiles_id", userFiles.opt("f_userfiles_id"));
                sellGas.put("f_userinfo_id", userInfo.opt("f_userinfo_id"));
                sellGas.put("f_user_name", userInfo.opt("f_user_name"));
                sellGas.put("f_user_type", (Object)userType);
                sellGas.put("f_gasproperties", (Object)gasProperties);
                sellGas.put("f_meter_classify", (Object)"\u7269\u8054\u7f51\u8868");
                sellGas.put("userinfo", (Object)userInfoId);
                sellGas.put("f_address", (Object)address);
                sellGas.put("f_meter_brand", gasBrand.opt("f_meter_brand"));
                sellGas.put("f_meternumber", (Object)meterNumber);
                sellGas.put("f_collection", 0);
                sellGas.put("f_delaypay", 0);
                sellGas.put("f_surplus_gas", 0);
                sellGas.put("f_haircut_gas", 0);
                sellGas.put("f_operator", (Object)"\u6284\u8868\u7cfb\u7edf");
                sellGas.put("f_charge_type", (Object)"\u81ea\u52a8\u4e0b\u8d26");
                sellGas.put("f_charge_state", (Object)"\u6709\u6548");
                sellGas.put("f_operat_type", (Object)"\u81ea\u52a8\u4e0b\u8d26");
                sellGas.put("f_describe", (Object)("\u7528\u6237 :" + userInfo.get("f_user_name") + "\u8fdb\u884c\u7269\u8054\u7f51\u8868\u6536\u8d39,\u81ea\u52a8\u4e0b\u8d26"));
                sellGas.put("f_state", (Object)"\u6709\u6548");
                sellGas.put("f_delaypay", 0);
                sellGas.put("f_filiale", userFiles.opt("f_filiale"));
                sellGas.put("f_filialeids", userFiles.opt("f_filialeids"));
                sellGas.put("f_outlets", userFiles.opt("f_outlets"));
                sellGas.put("f_orgstr", userFiles.opt("f_orgstr"));
                sellGas.put("f_orgid", userFiles.opt("f_orgid"));
                sellGas.put("f_depid", userFiles.opt("f_depid"));
                sellGas.put("f_orgname", userFiles.opt("f_orgname"));
                sellGas.put("f_depname", userFiles.opt("f_depname"));
                int sellGasId = new JSONObject(this.entityServer.partialSave("t_sellinggas", sellGas)).getInt("id");
                this.sqlServer.run("UPDATE t_handplan SET f_sell_id = '" + sellGasId + "' WHERE id = '" + handPlanId + "'");
                this.sqlServer.run("UPDATE t_chargeprice SET f_charge_id = '" + sellGasId + "' WHERE f_hand_id = '" + handPlanId + "'");
            }
        }
        if (realUseGas < 0.0) {
            usedGas = lastUsedGas;
        }
        this.updateUserFiles(userFiles, usedGas, curBalance, uploadTimes, params, handDate, useGasAmount);
        if (saleVersion == SaleVersionEnum.Vue_V1) {
            JSONObject userInfoData = new JSONObject();
            userInfoData.put("version", userInfo.get("version"));
            userInfoData.put("f_userinfo_id", (Object)userFiles.getString("f_userinfo_id"));
            userInfoData.put("f_balance", (Object)curBalance);
            this.entityServer.partialSave("t_userinfo", userInfoData);
        }
        result.put("lastBalance", balanceValue);
        result.put("balance", (Object)curBalance);
        result.put("useGas", usedGas);
        result.put("daySettlementIgnore", enableDaySettlement ? 1 : 0);
        result.put("firstIgnore", isFirstIgnore ? 1 : 0);
        result.put("totalFee", userFiles.opt("f_total_fee"));
        return result;
    }

    private void updateUserFiles(JSONObject userFiles, double usedGas, BigDecimal curBalance, int uploadTimes, JSONObject params, String handDate, double useGasAmount) throws Exception {
        JSONObject userFilesData = new JSONObject();
        userFilesData.put("version", userFiles.get("version"));
        userFilesData.put("f_user_id", userFiles.get("f_user_id"));
        userFilesData.put("f_userfiles_id", userFiles.opt("f_userfiles_id"));
        userFilesData.put("f_meter_base", usedGas);
        userFilesData.put("f_balance_amount", (Object)curBalance);
        userFilesData.put("f_meteread_number", uploadTimes);
        userFilesData.put("f_meteread_maxid", params.opt("f_meteread_maxid"));
        userFilesData.put("f_simplehand_maxid", params.opt("f_simplehand_id"));
        userFilesData.put("f_meteread_date", params.opt("f_insert_date"));
        userFilesData.put("f_hand_date", (Object)handDate);
        userFilesData.put("f_total_usegas_amount", useGasAmount);
        this.entityServer.partialSave("t_userfiles", userFilesData);
    }

    public JSONObject gasFeeCalculate(Object value, Object priceId, JSONObject userFiles, Object peopleNum, String handDate) {
        JSONObject params = new JSONObject();
        JSONObject model = new JSONObject();
        model.put("f_price_id", priceId);
        model.put("f_userinfo_id", userFiles.get("f_userinfo_id"));
        model.put("f_user_id", userFiles.get("f_user_id"));
        model.put("userId", userFiles.get(CompatTools.getUserFilesId()));
        model.put("f_open_date", userFiles.opt("f_open_date"));
        params.put("model", (Object)model);
        params.put("isGasValue", 0);
        params.put("value", value);
        params.put("f_people_num", peopleNum);
        params.put("f_filialeid", userFiles.opt("f_filialeid"));
        params.put("f_orgid", userFiles.opt("f_orgid"));
        params.put("f_filiale", userFiles.opt("f_filiale"));
        params.put("f_filialeids", userFiles.opt("f_filialeids"));
        params.put("f_hand_date", (Object)handDate);
        return (JSONObject)this.logicServer.run("gasfeeCalculate", params);
    }
}

