/*
 * Decompiled with CFR 0.152.
 */
package com.aote.webmeter.tools.tcp;

import com.af.plugins.ConvertTools;
import com.aote.logic.LogicServer;
import com.aote.webmeter.enums.MsgTypeEnum;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.codec.DecoderException;
import org.apache.log4j.Logger;
import org.json.JSONObject;

public class TcpTools {
    private static final Logger LOG = Logger.getLogger(TcpTools.class);
    private static final Map<String, ChannelData> CHANNEL_MAP = new ConcurrentHashMap<String, ChannelData>();
    private static final ThreadLocal<String> CHANNEL_ADDRESS = new ThreadLocal();

    public static JSONObject getChannelData(String address, String getChannelDataName, JSONObject params, LogicServer service) {
        ChannelData data = CHANNEL_MAP.get(address);
        if (data != null) {
            JSONObject channelParams = null;
            params.put("address", (Object)address);
            String result = String.valueOf(service.run(getChannelDataName, params));
            if (result != null) {
                data.params = channelParams = new JSONObject(result);
            }
            return channelParams;
        }
        return null;
    }

    public static String send(String message) throws DecoderException, IOException {
        return TcpTools.send(CHANNEL_ADDRESS.get(), message);
    }

    public static String send(String key, String message) throws IOException, DecoderException {
        ChannelData data = CHANNEL_MAP.get(key);
        if (data != null) {
            byte[] sendMsgBytes;
            switch (data.msgTypeEnum) {
                default: {
                    sendMsgBytes = message.getBytes();
                    break;
                }
                case BASE64: {
                    sendMsgBytes = ConvertTools.base64Decode((byte[])message.getBytes());
                    break;
                }
                case HEX: {
                    sendMsgBytes = ConvertTools.hexStrToByte((String)message);
                    break;
                }
                case HEX_BASE64: {
                    sendMsgBytes = ConvertTools.base64Decode((byte[])ConvertTools.hexStrToByte((String)message));
                }
            }
            ByteBuffer outBuffer = ByteBuffer.wrap(sendMsgBytes);
            data.channel.write(outBuffer);
            return "ok";
        }
        return "\u5ba2\u6237\u7aef\u4e0d\u5728\u7ebf\uff0c\u8bf7\u7a0d\u540e\u5c1d\u8bd5";
    }

    public static void remove(String key) throws IOException {
        SocketChannel channel = TcpTools.CHANNEL_MAP.get((Object)key).channel;
        if (channel != null) {
            LOG.debug((Object)("TCP\u7ba1\u9053\u9500\u6bc1\uff1a" + channel.getRemoteAddress()));
            if (channel.isOpen()) {
                channel.close();
            }
        }
        CHANNEL_MAP.remove(key);
        CHANNEL_ADDRESS.remove();
    }

    public static void setChannelMapValue(String key, ChannelData value) {
        CHANNEL_MAP.put(key, value);
    }

    public static void setChannelAddress(String key) {
        CHANNEL_ADDRESS.set(key);
    }

    public static class ChannelData {
        MsgTypeEnum msgTypeEnum;
        SocketChannel channel;
        JSONObject params;

        public ChannelData(MsgTypeEnum m, SocketChannel c) {
            this.msgTypeEnum = m;
            this.channel = c;
        }
    }
}

