/*
 * Decompiled with CFR 0.152.
 */
package com.aote.webmeter.common.utils;

public class Condition {
    public static final String SQL_GRAMMAR_TAG = "@";
    private final StringBuilder value;

    public static Condition build() {
        return new Condition();
    }

    private Condition() {
        this.value = new StringBuilder();
    }

    private Condition(String initValue) {
        this.value = new StringBuilder(initValue);
    }

    public String getValue() {
        return this.value.toString();
    }

    private Condition simpleAppend(String column, String conditionType, Object value) {
        String valueStr = String.valueOf(value);
        if (valueStr.startsWith(SQL_GRAMMAR_TAG)) {
            valueStr = valueStr.substring(1);
            this.value.append(column).append(" ").append(conditionType).append(" ").append(valueStr);
        } else {
            this.value.append(column).append(" ").append(conditionType).append(" ").append("'").append(valueStr).append("'");
        }
        return this;
    }

    private Condition inAppend(String column, String conditionType, Object ... value) {
        this.value.append(column).append(" ").append(conditionType).append(" (");
        for (Object item : value) {
            this.value.append("'").append(item).append("'").append(",");
        }
        this.value.deleteCharAt(this.value.length() - 1).append(")");
        return this;
    }

    public Condition eq(String column, Object value) {
        return this.simpleAppend(column, "=", value);
    }

    public Condition neq(String column, Object value) {
        return this.simpleAppend(column, "!=", value);
    }

    public Condition greaterThan(String column, Object value) {
        return this.simpleAppend(column, ">", value);
    }

    public Condition greaterThanEq(String column, Object value) {
        return this.simpleAppend(column, ">=", value);
    }

    public Condition lessThan(String column, Object value) {
        return this.simpleAppend(column, "<", value);
    }

    public Condition lessThanEq(String column, Object value) {
        return this.simpleAppend(column, "<=", value);
    }

    public Condition like(String column, Object value) {
        return this.simpleAppend(column, "LIKE", "%" + value + "%");
    }

    public Condition leftLike(String column, Object value) {
        return this.simpleAppend(column, "LIKE", "%" + value);
    }

    public Condition rightLike(String column, Object value) {
        return this.simpleAppend(column, "LIKE", value + "%");
    }

    public Condition in(String column, Object ... value) {
        return this.inAppend(column, "IN", value);
    }

    public Condition notIn(String column, Object ... value) {
        return this.inAppend(column, "NOT IN", value);
    }

    public Condition isNull(String column) {
        this.value.append(column).append(" ").append("IS NULL");
        return this;
    }

    public Condition isNotNull(String column) {
        this.value.append(column).append(" ").append("IS NOT NULL");
        return this;
    }

    public Condition and() {
        this.value.append("\n\t  AND ");
        return this;
    }

    public Condition or() {
        this.value.append("\n\t  OR ");
        return this;
    }

    public Condition asFirst(Condition condition) {
        this.value.append("(").append((CharSequence)condition.value).append(")");
        return this;
    }

    public String toString() {
        return this.value.toString();
    }
}

