/*
 * Decompiled with CFR 0.152.
 */
package com.aote.webmeter.common.modules.nbiot;

import com.aote.util.JsonHelper;
import com.aote.webmeter.common.dao.UserFilesDao;
import com.aote.webmeter.common.modules.AbstractRunInstruct;
import com.aote.webmeter.common.modules.nbiot.param.ChangeMeterParams;
import com.aote.webmeter.common.modules.nbiot.param.OpenAccountParams;
import com.aote.webmeter.common.template.pour.RunTemplatePour;
import com.aote.webmeter.common.template.result.RunInstructTemplateResult;
import com.aote.webmeter.enums.business.IOTDockingModeEnum;
import com.aote.webmeter.enums.business.InstructStateEnum;
import com.aote.webmeter.tools.iot.DeviceManagementTools;
import com.aote.webmeter.tools.iot.IotCommonTools;
import com.aote.webmeter.tools.iot.onenet.OnenetRestTools;
import java.util.Optional;
import org.json.JSONObject;

public abstract class NbIotRunInstruct
implements AbstractRunInstruct {
    protected final UserFilesDao userFilesDao;

    protected NbIotRunInstruct(UserFilesDao userFilesDao) {
        this.userFilesDao = userFilesDao;
    }

    @Override
    public RunTemplatePour runOpenAccount() {
        return (getInstructDto, templatePourExtraParams) -> {
            RunInstructTemplateResult.Builder resultBuilder;
            JSONObject requestResult;
            OpenAccountParams content = (OpenAccountParams)JsonHelper.toParse((JSONObject)new JSONObject(getInstructDto.getF_instruct_content()), OpenAccountParams.class);
            IOTDockingModeEnum dockingModeEnum = getInstructDto.getF_iot_type();
            if (dockingModeEnum == IOTDockingModeEnum.TELECOM) {
                IotCommonTools.setIsAep(content.getIsAep().getValue());
                requestResult = DeviceManagementTools.regDevice(content.getImei(), getInstructDto.getF_meternumber());
            } else if (dockingModeEnum == IOTDockingModeEnum.ONENET) {
                JSONObject params = new JSONObject();
                params.put("title", (Object)getInstructDto.getF_meternumber());
                params.put("mydevice", (Object)getInstructDto.getF_meternumber());
                params.put("protocol", (Object)"NBCoAP");
                requestResult = OnenetRestTools.createDevice(params, content.getImei(), "000000000000000");
            } else {
                requestResult = new JSONObject();
                requestResult.put("code", -1);
                requestResult.put("msg", (Object)("\u6ce8\u518c\u65f6\u6536\u5230\u672a\u77e5\u7684\u5e73\u53f0\u7c7b\u578b\uff1a" + dockingModeEnum.getValue()));
            }
            int code = requestResult.getInt("code");
            if (code == 0) {
                String deviceId = requestResult.getString("msg");
                this.userFilesDao.updateMeterDeviceId(getInstructDto.getF_meternumber(), deviceId);
                resultBuilder = new RunInstructTemplateResult.Builder().state(InstructStateEnum.SUCCESSFUL);
            } else {
                resultBuilder = new RunInstructTemplateResult.Builder().state(InstructStateEnum.FAILED).receiveMsg(requestResult.getString("msg"));
            }
            return resultBuilder.build();
        };
    }

    @Override
    public RunTemplatePour runChangeMeter() {
        return (getInstructDto, templatePourExtraParams) -> {
            JSONObject requestResult;
            ChangeMeterParams content = (ChangeMeterParams)JsonHelper.toParse((JSONObject)new JSONObject(getInstructDto.getF_instruct_content()), ChangeMeterParams.class);
            if (Optional.ofNullable(content.getDeviceId()).isPresent()) {
                IOTDockingModeEnum dockingModeEnum = getInstructDto.getF_iot_type();
                if (dockingModeEnum == IOTDockingModeEnum.TELECOM) {
                    IotCommonTools.setIsAep(content.getIsAep().getValue());
                    requestResult = DeviceManagementTools.cancelDevice(content.getDeviceId());
                } else if (dockingModeEnum == IOTDockingModeEnum.ONENET) {
                    requestResult = OnenetRestTools.deleteDevice(content.getDeviceId());
                } else {
                    requestResult = new JSONObject();
                    requestResult.put("code", -1);
                    requestResult.put("msg", (Object)("\u6ce8\u9500\u65f6\u6536\u5230\u672a\u77e5\u7684\u5e73\u53f0\u7c7b\u578b\uff1a" + dockingModeEnum.getValue()));
                }
            } else {
                requestResult = new JSONObject();
                requestResult.put("code", -1);
                requestResult.put("msg", (Object)"\u8bbe\u5907ID\u4e3anull");
            }
            int code = requestResult.getInt("code");
            RunInstructTemplateResult.Builder resultBuilder = code == 0 ? new RunInstructTemplateResult.Builder().state(InstructStateEnum.SUCCESSFUL) : new RunInstructTemplateResult.Builder().state(InstructStateEnum.FAILED);
            return resultBuilder.receiveMsg(requestResult.getString("msg")).build();
        };
    }
}

