package com.aote.webmeter.common.modules.nbiot;

import com.aote.webmeter.common.dto.GetChangeMeterDataDto;
import com.aote.webmeter.common.dto.GetOpenAccountDataDto;
import com.aote.webmeter.common.modules.AbstractSaveInstruct;
import com.aote.webmeter.common.modules.nbiot.param.ChangeMeterParams;
import com.aote.webmeter.common.modules.nbiot.param.OpenAccountParams;
import com.aote.webmeter.common.template.pour.SaveTemplatePour;

/**
 * NB-IOT平台物联网表保存指令
 *
 * @author Mr.river
 */
public abstract class NbIotSaveInstruct implements AbstractSaveInstruct {

    @Override
    public SaveTemplatePour saveOpenAccount(){
        return dto -> {
            GetOpenAccountDataDto openAccountDataDto = (GetOpenAccountDataDto) dto;
            OpenAccountParams result = new OpenAccountParams();
            result.setImei(openAccountDataDto.getF_imei());
            result.setIotType(openAccountDataDto.getF_iot_type());
            result.setIsAep(openAccountDataDto.getF_terminal_id());
            return result;
        };
    }

    @Override
    public SaveTemplatePour saveChangeMeter(){
        return dto -> {
            GetChangeMeterDataDto changeMeterDataDto = (GetChangeMeterDataDto) dto;
            ChangeMeterParams result = new ChangeMeterParams();
            result.setDeviceId(changeMeterDataDto.getF_device_id());
            result.setIotType(changeMeterDataDto.getF_iot_type());
            result.setIsAep(changeMeterDataDto.getF_terminal_id());
            return result;
        };
    }
}
