package com.aote.webmeter.common.modules;

import com.aote.webmeter.common.template.pour.RunTemplatePour;
import com.aote.webmeter.enums.BusinessExceptionCodeEnum;
import com.aote.webmeter.exception.WebmeterException;

/**
 * 抽象物联网表
 *
 * @author Mr.river
 */
public interface AbstractRunInstruct {
    /**
     * 执行开户指令
     * @return 调用执行指令模板时注入业务
     */
    RunTemplatePour runOpenAccount();
    /**
     * 执行换表/注销指令
     * @return 调用执行指令模板时注入业务
     */
    RunTemplatePour runChangeMeter();
    /**
     * 执行充值指令
     * @return 调用执行指令模板时注入业务
     */
    default RunTemplatePour runGasRecharge(){
        throw new WebmeterException(BusinessExceptionCodeEnum.NO_IMPL_METHOD_BY_INSTRUCT);
    }
    /**
     * 执行调价指令
     * @return 调用执行指令模板时注入业务
     */
    default RunTemplatePour runSetPrice(){
        throw new WebmeterException(BusinessExceptionCodeEnum.NO_IMPL_METHOD_BY_INSTRUCT);
    }
    /**
     * 执行阀控指令
     * @return 调用执行指令模板时注入业务
     */
    RunTemplatePour runValveControl();
}
