package com.aote.webmeter.tools.iot.aep;

import com.af.plugins.ConvertTools;
import com.af.plugins.JsonTools;
import com.aote.webmeter.tools.WebMeterInfo;
import com.ctg.ag.sdk.biz.AepDeviceCommandClient;
import com.ctg.ag.sdk.biz.AepDeviceCommandLwmProfileClient;
import com.ctg.ag.sdk.biz.AepDeviceManagementClient;
import com.ctg.ag.sdk.biz.aep_device_command.CreateCommandRequest;
import com.ctg.ag.sdk.biz.aep_device_command_lwm_profile.CreateCommandLwm2mProfileRequest;
import com.ctg.ag.sdk.biz.aep_device_management.CreateDeviceRequest;
import com.ctg.ag.sdk.biz.aep_device_management.DeleteDeviceRequest;
import org.json.JSONObject;

import java.nio.charset.StandardCharsets;

/**
 * 原生AEP兼容插件
 *
 * @author 林
 * @date 2022/8/10 17:46
 * @apiNote 电信AEP无profile文件透传指令
 */
public class AEPTools {
    /**
     * 电信aep下发指令,无profile文件透传指令
     *
     * @param deviceId 设备ID
     * @param contentData  下发参数
     * @return 执行结果
     */
    public static JSONObject getRet(String deviceId, String contentData) throws Exception {
        String appKey = WebMeterInfo.getString("aepAPIKey");
        String appSecret = WebMeterInfo.getString("aepSecret");
        String mastKey = WebMeterInfo.getString("mastKey");
        AepDeviceCommandClient client = null;
        try {
            client = AepDeviceCommandClient.newClient().appKey(appKey).appSecret(appSecret).build();;
            CreateCommandRequest request = new CreateCommandRequest();
            request.setParamMasterKey(mastKey);
            request.addParamMasterKey(mastKey);
            JSONObject params = new JSONObject();
            params.put("appId", appKey);
            params.put("secret", appSecret);
            params.put("deviceId", deviceId);
            params.put("operator", "业务系统");
            params.put("productId", WebMeterInfo.getString("appId"));
            params.put("ttl", 86400);
            JSONObject content = new JSONObject();
            content.put("dataType", 2);
            content.put("payload", contentData);
            params.put("content", content);
            byte[] bytes = ConvertTools.strToBytes(params.toString());
            request.setBody(bytes);
            byte[] resultByte = client.CreateCommand(request).getBody();
            return JsonTools.convertToJson(new String(resultByte, StandardCharsets.UTF_8));
        } finally {
            if (client != null) {
                client.shutdown();
            }
        }
    }

    /**
     * 电信aep下发指令,有profile文件透传指令
     *
     * @param deviceId 设备ID
     * @param contentData  下发参数
     * @return
     * @throws Exception
     */
    public static JSONObject getRetProfile(String deviceId, String contentData,String method,String serviceId) throws Exception {
        JSONObject paras = new JSONObject();
        paras.put(method,contentData);
        return getRetProfile(deviceId, paras, method, serviceId);
    }

    public static JSONObject getRetProfile(String deviceId, JSONObject contentData, String method, String serviceId) throws Exception {
        String appKey = WebMeterInfo.getString("aepAPIKey");
        String appSecret = WebMeterInfo.getString("aepSecret");
        String mastKey = WebMeterInfo.getString("mastKey");
        AepDeviceCommandLwmProfileClient client = null;
        try {
            client = AepDeviceCommandLwmProfileClient.newClient().appKey(appKey).appSecret(appSecret).build();
            CreateCommandLwm2mProfileRequest request = new CreateCommandLwm2mProfileRequest();
            request.setParamMasterKey(mastKey);
            request.addParamMasterKey(mastKey);
            JSONObject params = new JSONObject();
            params.put("appId", appKey);
            params.put("secret", appSecret);
            params.put("deviceId", deviceId);
            params.put("operator", "业务系统");
            params.put("productId", WebMeterInfo.getString("appId"));
            params.put("ttl", 86400);
            JSONObject content = new JSONObject();
            content.put("serviceId", serviceId);
            content.put("method", method);
            content.put("paras", contentData);
            params.put("command", content);
            byte[] bytes = ConvertTools.strToBytes(params.toString());
            request.setBody(bytes);
            byte[] resultByte = client.CreateCommandLwm2mProfile(request).getBody();
            JSONObject result = JsonTools.convertToJson(new String(resultByte, StandardCharsets.UTF_8));
            JSONObject resultData = result.getJSONObject("result");
            return new JSONObject().put("commandId", resultData.getString("deviceId") + "-" + resultData.getString("commandId"));
        } finally {
            if (client != null) {
                client.shutdown();
            }
        }
    }

    /**
     * 电信aep注册设备
     *
     * @param imei        IMEI
     * @param meterNumber 表号
     * @return 执行结果
     */
    public static JSONObject getRegister(String imei, String meterNumber) throws Exception {
        String appKey = WebMeterInfo.getString("aepAPIKey");
        String appSecret = WebMeterInfo.getString("aepSecret");
        String mastKey = WebMeterInfo.getString("mastKey");
        AepDeviceManagementClient client = null;
        try {
            client = AepDeviceManagementClient.newClient().appKey(appKey).appSecret(appSecret).build();
            CreateDeviceRequest request = new CreateDeviceRequest();
            request.setParamMasterKey(mastKey);
            request.addParamMasterKey(mastKey);
            JSONObject count = new JSONObject();
            count.put("deviceName", meterNumber);
            count.put("deviceSn", meterNumber);
            count.put("imei", imei);
            count.put("productId", WebMeterInfo.getString("appId"));
            count.put("operator", "业务系统");
            JSONObject other = new JSONObject();
            other.put("autoObserver", 0);
            count.put("other", other);
            byte[] bytes = ConvertTools.strToBytes(count.toString());
            request.setBody(bytes);
            byte[] resultByte = client.CreateDevice(request).getBody();
            return JsonTools.convertToJson(new String(resultByte, StandardCharsets.UTF_8));
        } finally {
            if (client != null) {
                client.shutdown();
            }
        }
    }

    /**
     * 电信aep注销设备
     *
     * @param deviceId 设备号
     * @return 执行结果
     */
    public static JSONObject getDelete(String deviceId) throws Exception {
        String appKey = WebMeterInfo.getString("aepAPIKey");
        String appSecret = WebMeterInfo.getString("aepSecret");
        String mastKey = WebMeterInfo.getString("mastKey");
        String productId = WebMeterInfo.getString("appId");
        AepDeviceManagementClient client = null;
        try {
            client = AepDeviceManagementClient.newClient().appKey(appKey).appSecret(appSecret).build();
            DeleteDeviceRequest request = new DeleteDeviceRequest();
            request.setParamMasterKey(mastKey);
            request.setParamProductId(productId);
            request.setParamDeviceIds(deviceId);
            byte[] resultByte = client.DeleteDevice(request).getBody();
            return JsonTools.convertToJson(new String(resultByte, StandardCharsets.UTF_8));
        } finally {
            if (client != null) {
                client.shutdown();
            }
        }
    }
}
