package com.aote.webmeter.tools.iot;

import com.af.plugins.HttpDeleteWithBody;
import com.aote.webmeter.enums.IOTBusinessTypeEnum;
import com.aote.webmeter.enums.NotifyTypeEnum;
import com.aote.webmeter.enums.WebmeterPropertiesIOTEnum;
import com.aote.webmeter.tools.WebMeterInfo;
import com.aote.webmeter.tools.iot.aep.AEPTools;
import org.apache.http.client.methods.HttpPost;
import org.apache.log4j.Logger;
import org.json.JSONObject;

import java.io.IOException;

/**
 * 电信IOT平台指令发送工具
 *
 * @author Mr.river
 */
public class SignalDeliveryTools {
    private static final Logger LOGGER = Logger.getLogger(SignalDeliveryTools.class);

    /**
     * 发送命令请求（自主API）
     *
     * @param serviceId 服务ID
     * @param method    命令名称
     * @param deviceId  设备ID
     * @param jo        命令参数JSON
     * @return 请求结果JSON
     */
    public static JSONObject myPostCommand(String serviceId, String method, String deviceId, JSONObject jo, Integer expireTime) throws IOException {
        int isAep = IotCommonTools.getIsAep();
        String callbackUrl;
        if (isAep == 1) {
            callbackUrl = WebMeterInfo.getString(WebmeterPropertiesIOTEnum.AEP_CALLBACK_URL);
        } else if (isAep == 0) {
            callbackUrl = WebMeterInfo.getString(WebmeterPropertiesIOTEnum.OC_CALLBACK_URL);
        } else {
            callbackUrl = WebMeterInfo.getString(WebmeterPropertiesIOTEnum.OC2_CALLBACK_URL);
        }
        Integer maxRetransmit = 3;

        JSONObject paramCommand = new JSONObject();
        paramCommand.put("serviceId", serviceId);
        paramCommand.put("method", method);
        paramCommand.put("paras", jo);

        if (expireTime == null) {
            expireTime = 0;
        }

        JSONObject content = new JSONObject();
        content.put("deviceId", deviceId);
        content.put("command", paramCommand);
        content.put("callbackUrl", callbackUrl);
        content.put("expireTime", expireTime);
        content.put("maxRetransmit", maxRetransmit);

        JSONObject result = IotCommonTools.post(IOTBusinessTypeEnum.SEND_COMMAND, new HttpPost(), content, null);

        if (result.has("errorEntity")) {
            throw new RuntimeException(result.toString());
        } else {
            return new JSONObject().put("commandId", result.get("commandId"));
        }
    }

    public static JSONObject myPostCommand(String serviceId, String method, String deviceId, JSONObject jo) throws Exception {
        String hasProfile = WebMeterInfo.getString("hasProfile");
        if (hasProfile.equals("1")) {
            return AEPTools.getRetProfile(deviceId, jo ,method,serviceId);
        } else {
            return myPostCommand(serviceId, method, deviceId, jo, 0);
        }
    }

    /**
     * 发送原生aep指令
     *
     * @param deviceId     设备ID
     * @param base64String 发送的指令内容
     * @return 请求结果
     */
    public static JSONObject myPostCommand(String deviceId, String base64String) throws Exception {
        return AEPTools.getRet(deviceId, base64String);
    }


    /**
     * 发送透传命令请求（即时）
     *
     * @param method       命令名称
     * @param deviceId     设备ID
     * @param base64String base64编码字符串
     * @return 请求结果JSON
     */
    public static JSONObject myPostCommand(String method, String deviceId, String base64String) throws IOException {
        return myPostCommand(method, deviceId, base64String, 0);
    }

    /**
     * 发送透传命令请求
     *
     * @param method       命令名称
     * @param deviceId     设备ID
     * @param base64String base64编码字符串
     * @param expireTime   等待时间
     * @return 请求结果JSON
     */
    public static JSONObject myPostCommand(String method, String deviceId, String base64String, Integer expireTime) throws IOException {
        JSONObject object = new JSONObject();
        object.put("rawData", base64String);
        return myPostCommand("RawData", method, deviceId, object, expireTime);
    }

    /**
     *
     * @param serviceId 服务ID
     * @param method    命令名称
     * @param deviceId  设备ID
     * @param base64String  base64编码字符串
     * hasProfile 是否有Profile文件，0否，1是
     * @return
     * @throws Exception
     */
    public static JSONObject myPostCommand(String serviceId, String method, String deviceId, String base64String) throws Exception {
        String hasProfile = WebMeterInfo.getString("hasProfile");
        if (hasProfile.equals("1")) {
            return AEPTools.getRetProfile(deviceId, base64String,method,serviceId);
        } else {
            return myPostCommand(serviceId, method, deviceId, base64String, 0);
        }
    }

    public static JSONObject myPostCommand(String serviceId, String method, String deviceId, String base64String, Integer expireTime) throws IOException {
        JSONObject object = new JSONObject();
        object.put("rawData", base64String);
        String serviceIdValue;
        if (IotCommonTools.getIsAep() == 1) {
            serviceIdValue = serviceId;
        } else {
            serviceIdValue = "RawData";
        }
        return myPostCommand(serviceIdValue, method, deviceId, object, expireTime);
    }

    /**
     * 发送订阅请求
     *
     * @param notifyTypeEnum 订阅类型
     * @param callBackUrl    回调地址
     * @return 请求结果JSON
     */
    public static JSONObject subscribe(NotifyTypeEnum notifyTypeEnum, String callBackUrl) throws IOException {
        JSONObject content = new JSONObject();
        content.put("notifyType", notifyTypeEnum.getValue());
        content.put("callbackUrl", callBackUrl);

        JSONObject result = IotCommonTools.post(IOTBusinessTypeEnum.SUBSCRIPTIONS, new HttpPost(), content, null);

        if (result.has("errorEntity")) {
            LOGGER.error("IOT接口调用错误！，信息：" + result);
            return null;
        } else {
            return result;
        }
    }

    /**
     * 删除所有订阅
     *
     * @return 请求结果JSON
     */
    public static JSONObject deleteAllSubscribe() throws IOException {
        JSONObject result = IotCommonTools.post(IOTBusinessTypeEnum.SUBSCRIPTIONS, new HttpDeleteWithBody(), null, null);

        if (result.has("errorEntity")) {
            LOGGER.error("IOT接口调用错误！，信息：" + result);
            return null;
        } else {
            return result;
        }
    }
}
