package com.aote.webmeter.tools;

import com.aote.webmeter.enums.SaleVersionEnum;
import com.aote.webmeter.enums.business.OpenAccountStateEnum;
import org.json.JSONObject;

import java.util.Objects;

/**
 * 物联网表-营收业务兼容性组件
 *
 * @author 物联网表小组
 */
public class CompatTools {

    /**
     * 获取查询表具信息的基础条件表达式
     *
     * @param userId 表档案ID
     * @return 条件表达式
     */
    public static String getBasicCondition(Object userId) {
        String userIdValue = String.valueOf(userId);
        switch (WebMeterInfo.getSaleNameEnum()) {
            case Vue_V1:
            case Vue_V2:
                return "t_userfiles.f_user_id = '" + userIdValue + "'";
            case SILVER_LIGHT:
            case SILVER_LIGHT2:
                return "t_userfiles.id = '" + userIdValue + "'";
            case Vue_V3:
            case V4:
            default:
                return "t_userfiles.f_userfiles_id = '" + userIdValue + "'";
        }
    }

    /**
     * 获取查询表具信息的基础条件表达式
     *
     * @param object 含有表档案原始ID的查询结果
     * @return 条件表达式
     */
    public static String getBasicCondition(JSONObject object) {
        switch (WebMeterInfo.getSaleNameEnum()) {
            case Vue_V1:
            case Vue_V2:
                return "t_userfiles.f_user_id = '" + object.getString("f_user_id") + "'";
            case SILVER_LIGHT:
            case SILVER_LIGHT2:
                return "t_userfiles.id = '" + object.getString("f_user_id") + "'";
            case Vue_V3:
            case V4:
            default:
                return "t_userfiles.f_userfiles_id = '" + object.getString("f_userfiles_id") + "'";
        }
    }

    /**
     * 获取更新换表记录的SQL语句
     *
     * @param id        换表记录ID
     * @param isSuccess 是否成功
     * @return SQL语句
     */
    public static String getUpdateChangeMeterSql(Object id, Boolean isSuccess) {
        String idValue = String.valueOf(id);
        String syncWorld = isSuccess ? "成功" : "失败";
        switch (WebMeterInfo.getSaleNameEnum()) {
            case Vue_V1:
            case Vue_V2:
                return "UPDATE t_changemeter SET f_sendsuccess = '" + syncWorld + "' WHERE id = '" + idValue + "'";
            case SILVER_LIGHT:
            case SILVER_LIGHT2:
                return "UPDATE t_changmeter SET f_sendsuccess = '" + syncWorld + "' WHERE id = '" + idValue + "'";
            case Vue_V3:
            case V4:
            default:
                return "UPDATE t_changetables SET f_sendsuccess = '" + syncWorld + "' WHERE id = '" + idValue + "'";
        }
    }

    public static String getUpdateChangeMeterSql(Object id) {
        return getUpdateChangeMeterSql(id, true);
    }

    /**
     * 获取更新调价记录的SQL语句
     *
     * @param id            调价记录ID
     * @param updateColumns 更新列
     * @return SQL语句
     */
    public static String getUpdateSetPriceMeterSql(Object id, String updateColumns) {
        if (updateColumns == null) {
            updateColumns = "f_sendsuccess";
        }
        String idValue = String.valueOf(id);
        switch (WebMeterInfo.getSaleNameEnum()) {
            case SILVER_LIGHT:
                return "UPDATE t_changestairpricedetail SET " + updateColumns + " = '成功' where id = '" + idValue + "'";
            case SILVER_LIGHT2:
                return "UPDATE t_changestairprice SET " + updateColumns + " = '成功' where id = '" + idValue + "'";
            case Vue_V1:
            case Vue_V2:
            case Vue_V3:
            case V4:
            default:
                return "UPDATE t_pricechange SET " + updateColumns + " = '成功' WHERE id = '" + idValue + "'";
        }
    }

    /**
     * 获取更新充值/退费记录的SQL语句
     *
     * @param id        充值/退费记录ID
     * @param isSuccess 是否成功
     * @return SQL语句
     */
    public static String getUpdateChargeMeterSql(Object id, Boolean isSuccess) {
        String idValue = String.valueOf(id);
        String syncWorld = isSuccess ? "成功" : "失败";
        return "UPDATE t_sellinggas SET f_sendsuccess = '" + syncWorld + "' WHERE id = '" + idValue + "'";
    }

    public static String getUpdateChargeMeterSql(Object id) {
        return getUpdateChargeMeterSql(id, true);
    }

    /**
     * 获取更新冲正记录的SQL语句
     *
     * @param id        冲正记录ID
     * @param isSuccess 是否成功
     * @return SQL语句
     */
    public static String getUpdateCancelChargeMeterSql(Object id, Boolean isSuccess) {
        String idValue = String.valueOf(id);
        String syncWorld = isSuccess ? "成功" : "失败";
        switch (WebMeterInfo.getSaleNameEnum()) {
            case SILVER_LIGHT:
            case SILVER_LIGHT2:
                return "UPDATE t_correctrecord SET f_sendsuccess = '" + syncWorld + "' WHERE id = '" + idValue + "'";
            case Vue_V1:
            case Vue_V2:
            case Vue_V3:
            case V4:
            default:
                return "UPDATE t_sellinggas SET f_sendsuccess = '" + syncWorld + "' WHERE id = '" + idValue + "'";
        }
    }

    public static String getUpdateCancelChargeMeterSql(Object id) {
        return getUpdateCancelChargeMeterSql(id, true);
    }

    /**
     * 获取更新换表补气记录的SQL语句
     *
     * @param id        换表补气记录ID
     * @param isSuccess 是否成功
     * @return SQL语句
     */
    public static String getUpdateSupplyGasMeterSql(Object id, Boolean isSuccess) {
        String idValue = String.valueOf(id);
        String syncWorld = isSuccess ? "成功" : "失败";
        switch (WebMeterInfo.getSaleNameEnum()) {
            case SILVER_LIGHT:
            case SILVER_LIGHT2:
                return "UPDATE t_changmeter SET f_isSupplyGas = '" + syncWorld + "',f_sendsuccess = '" + syncWorld + "'  WHERE id = '" + idValue + "'";
            case Vue_V1:
            case Vue_V2:
            case Vue_V3:
            case V4:
            default:
                return "UPDATE t_fillgas SET f_sendsuccess = '" + syncWorld + "' WHERE id = '" + idValue + "'";
        }
    }

    public static String getUpdateSupplyGasMeterSql(Object id) {
        return getUpdateSupplyGasMeterSql(id, true);
    }

    /**
     * 获取更新补费扣费记录的SQL语句
     *
     * @param id 换表补气记录ID
     * @return SQL语句
     */
    public static String getUpdateAdjustMoneyMeterSql(Object id, Boolean isSuccess) {
        String idValue = String.valueOf(id);
        String syncWorld = isSuccess ? "成功" : "失败";
        switch (WebMeterInfo.getSaleNameEnum()) {
            case SILVER_LIGHT:
            case SILVER_LIGHT2:
                return "UPDATE t_cbgas SET f_sendsuccess = '" + syncWorld + "' WHERE id = '" + idValue + "'";
            case Vue_V1:
            case Vue_V2:
            case Vue_V3:
            case V4:
            default:
                return "UPDATE t_fillgas SET f_sendsuccess = '" + syncWorld + "' WHERE id = '" + idValue + "'";
        }
    }

    public static String getUpdateAdjustMoneyMeterSql(Object id) {
        return getUpdateAdjustMoneyMeterSql(id, true);
    }

    /**
     * 获取更新区域记录的SQL语句
     *
     * @param object 业务记录JSON
     * @return SQL语句
     */
    public static String getUpdateSyncAreasSql(JSONObject object) {
        String paramsValue;
        switch (WebMeterInfo.getSaleNameEnum()) {
            case SILVER_LIGHT:
            case SILVER_LIGHT2:
                paramsValue = String.valueOf(object.get("f_districtname"));
                return "UPDATE t_userfiles SET f_isSyncAreas = '成功' WHERE f_districtname = '" + paramsValue + "'";
            case Vue_V1:
            case Vue_V2:
            case Vue_V3:
            case V4:
            default:
                paramsValue = String.valueOf(object.get("id"));
                return "UPDATE t_area SET f_sendsuccess = '成功' WHERE id = '" + paramsValue + "'";
        }
    }

    /**
     * 获取更新地址记录的SQL语句
     *
     * @param object 业务记录JSON
     * @return SQL语句
     */
    public static String getUpdateSyncAddressSql(JSONObject object) {
        String paramsValue;
        switch (WebMeterInfo.getSaleNameEnum()) {
            case SILVER_LIGHT:
            case SILVER_LIGHT2:
                paramsValue = String.valueOf(object.get("f_address"));
                return "UPDATE t_userfiles SET f_isSyncAddress = '成功' WHERE f_address = '" + paramsValue + "'";
            case Vue_V1:
            case Vue_V2:
            case Vue_V3:
            case V4:
            default:
                paramsValue = String.valueOf(object.get("id"));
                return "UPDATE t_user_address SET f_sendsuccess = '成功' WHERE id = '" + paramsValue + "'";
        }
    }

    /**
     * 获取更新表档案开户状态的SQL语句
     *
     * @param userId        表档案ID
     * @param isOpenAccount 是否开户
     * @return SQL语句
     */
    @Deprecated
    public static String getUpdateUserFilesSql(Object userId, Boolean isOpenAccount) {
        OpenAccountStateEnum stateEnum;
        if (isOpenAccount) {
            stateEnum = OpenAccountStateEnum.OPEN_ACCOUNT;
        } else {
            stateEnum = OpenAccountStateEnum.NO_ACCOUNT;
        }
        return getUpdateUserFilesSql(userId, stateEnum);
    }

    /**
     * 获取更新表档案开户状态的SQL语句
     *
     * @param userId        表档案ID
     * @param isOpenAccount 是否开户 (0,1,2,3)
     * @return SQL语句
     */
    public static String getUpdateUserFilesSql(Object userId, Integer isOpenAccount) {
        OpenAccountStateEnum stateEnum;
        switch (isOpenAccount) {
            case 1:
                stateEnum = OpenAccountStateEnum.OPEN_ACCOUNT;
                break;
            case 0:
                stateEnum = OpenAccountStateEnum.NO_ACCOUNT;
                break;
            case 2:
                stateEnum = OpenAccountStateEnum.READY_ACCOUNT;
                break;
            case 3:
            default:
                stateEnum = OpenAccountStateEnum.ERROR;
                break;
        }
        return getUpdateUserFilesSql(userId, stateEnum);
    }

    /**
     * 获取更新表档案开户状态的SQL语句
     *
     * @param userId    表档案ID
     * @param stateEnum 档案开户状态
     * @return SQL语句
     */
    public static String getUpdateUserFilesSql(Object userId, OpenAccountStateEnum stateEnum) {
        String type;
        String noSyncValue = "'未同步'";
        switch (stateEnum) {
            case OPEN_ACCOUNT:
                type = "f_sendsuccess = '成功',f_sync_sendsuccess = isnull(f_sync_sendsuccess," + noSyncValue + "),f_is_init = isnull(f_is_init," + noSyncValue + ")";
                break;
            case NO_ACCOUNT:
                type = "f_sendsuccess = " + noSyncValue + ",f_is_init = " + noSyncValue + ",f_sync_sendsuccess = " + noSyncValue;
                break;
            case READY_ACCOUNT:
                type = "f_sendsuccess = '待执行',f_sync_sendsuccess = isnull(f_sync_sendsuccess," + noSyncValue + "),f_is_init = isnull(f_is_init," + noSyncValue + ")";
                break;
            case ERROR:
            default:
                type = "f_sendsuccess = '失败',f_sync_sendsuccess = isnull(f_sync_sendsuccess," + noSyncValue + "),f_is_init = isnull(f_is_init," + noSyncValue + ")";
                break;
        }
        return getUpdateUserFilesSqlByUpdateColumns(type, userId);
    }

    /**
     * 获取更新表档案初始化状态的SQL语句
     *
     * @param userId 表档案ID
     * @param isInit 是否初始化
     * @return SQL语句
     */
    public static String getUpdateInitUserFilesSql(Object userId, Boolean isInit) {
        return getUpdateUserFilesSql(userId, "f_is_init", isInit);
    }

    /**
     * 获取更新表档案同步状态的SQL语句
     *
     * @param userId 表档案ID
     * @param isSync 是否同步
     * @return SQL语句
     */
    public static String getUpdateSyncUserFilesSql(Object userId, Boolean isSync) {
        return getUpdateUserFilesSql(userId, "f_sync_sendsuccess", isSync);
    }

    /**
     * 获取更新表档案自定义状态的SQL语句
     *
     * @param userId 表档案ID
     * @param isOK   自定义状态
     * @return SQL语句
     */
    public static String getUpdateUserFilesSql(Object userId, String columnName, Boolean isOK) {
        String type;
        if (isOK) {
            type = columnName + " = '成功'";
        } else {
            type = columnName + " = null";
        }
        return getUpdateUserFilesSqlByUpdateColumns(type, userId);
    }

    /**
     * 获取更新表档案的SQL语句
     *
     * @param updateColumns 更新列
     * @param userId        表档案ID
     * @return SQL语句
     */
    public static String getUpdateUserFilesSqlByUpdateColumns(String updateColumns, Object userId) {
        String userIdValue = String.valueOf(userId);
        String sql;
        switch (WebMeterInfo.getSaleNameEnum()) {
            case Vue_V1:
            case Vue_V2:
                sql = "UPDATE t_userfiles SET " + updateColumns + " WHERE f_user_id = '" + userIdValue + "'";
                break;
            case SILVER_LIGHT:
            case SILVER_LIGHT2:
                sql = "UPDATE t_userfiles SET " + updateColumns + " WHERE id = '" + userIdValue + "'";
                break;
            case Vue_V3:
            case V4:
            default:
                sql = "UPDATE t_userfiles SET " + updateColumns + " WHERE f_userfiles_id = '" + userIdValue + "'";
                break;
        }
        return WebMeterInfo.DATA_SOURCE_DIALECT.getSql(sql);
    }

    /**
     * 获取指令表名称
     *
     * @return 指令表名称
     */
    public static String getInstructTableName() {
        switch (WebMeterInfo.getSaleNameEnum()) {
            case SILVER_LIGHT:
            case SILVER_LIGHT2:
                return "t_webmeter_instruct";
            case Vue_V1:
            case Vue_V2:
            case Vue_V3:
            case V4:
            default:
                return "t_instruct";
        }
    }

    /**
     * 获取表档案主键字段名
     *
     * @return 表档案主键字段名
     */
    public static String getUserFilesId() {
        switch (WebMeterInfo.getSaleNameEnum()) {
            case Vue_V3:
            case V4:
                return "f_userfiles_id";
            case Vue_V1:
            case Vue_V2:
            case SILVER_LIGHT:
            case SILVER_LIGHT2:
            default:
                return "f_user_id";
        }
    }

    /**
     * 获取总购金额字段名
     *
     * @return 总购金额字段名
     */
    public static String getTotalFee() {
        switch (WebMeterInfo.getSaleNameEnum()) {
            case Vue_V3:
            case Vue_V2:
            case Vue_V1:
            case V4:
                return "f_total_fee";
            case SILVER_LIGHT:
            case SILVER_LIGHT2:
            default:
                return "f_meteramountnums";
        }
    }

    /**
     * 获取表档案主键原始字段名
     *
     * @return 表档案主键原始字段名
     */
    public static String getOriginalUserFilesId() {
        switch (WebMeterInfo.getSaleNameEnum()) {
            case Vue_V3:
            case V4:
                return "f_userfiles_id";
            case Vue_V1:
            case Vue_V2:
                return "f_user_id";
            case SILVER_LIGHT:
            case SILVER_LIGHT2:
            default:
                return "id";
        }
    }


    /**
     * 获取档案表底数原始字段名
     *
     * @param withTableName 是否包含表名
     * @return 档案表底数原始字段名
     */
    public static String getOriginalUserFilesMeterBase(Boolean withTableName) {
        switch (WebMeterInfo.getSaleNameEnum()) {
            case SILVER_LIGHT:
                if (withTableName) {
                    return "t_userfiles.lastinputgasnum";
                } else {
                    return "lastinputgasnum";
                }
            case SILVER_LIGHT2:
                if (withTableName) {
                    return "t_userinfo.lastinputgasnum";
                } else {
                    return "lastinputgasnum";
                }
            default:
                if (withTableName) {
                    return "t_userfiles.f_meter_base";
                } else {
                    return "f_meter_base";
                }
        }
    }

    public static String getOriginalUserFilesMeterBase() {
        return getOriginalUserFilesMeterBase(true);
    }

    /**
     * 根据表号及表状态获取指定查询列表具信息的Query参数JSON
     *
     * @param columns     查询列 默认：表号(f_meternumber),表档案ID(userid)
     * @param meterNumber 表号
     * @param tableState  表状态
     * @return 适用于SQL@webmeterGetBaseData的Query参数JSON
     */
    public static JSONObject getMeterInfoCondition(String columns, Object meterNumber, String tableState) {
        JSONObject result = new JSONObject();
        result.put("items", columns);
        String condition = "t_userfiles.f_meternumber = '" + meterNumber + "' ";
        switch (WebMeterInfo.getSaleNameEnum()) {
            case SILVER_LIGHT:
                result.put("items", columns + ",t_userfiles.f_userstate state");
                result.put("tableName", "t_userfiles");
                if (tableState != null) {
                    condition = condition + "and t_userfiles.f_userstate = '" + tableState + "'";
                } else {
                    condition = condition + "and t_userfiles.f_userstate IN ('停用','正常')";
                }
                result.put("condition", condition);
                break;
            case SILVER_LIGHT2:
                result.put("items", columns + ",t_userfiles.f_userstate state");
                result.put("tableName", "t_userfiles,t_userinfo");
                if (tableState != null) {
                    condition = condition + "and t_userinfo.f_userstate = '" + tableState + "' and t_userfiles.f_userstate = '" + tableState + "' ";
                } else {
                    condition = condition + "and t_userinfo.f_userstate IN ('停用','正常') and t_userfiles.f_userstate IN ('停用','正常') ";
                }
                condition = condition + "and t_userfiles.f_userinfoid = t_userinfo.f_userid";
                result.put("condition", condition);
                break;
            case Vue_V1:
            case Vue_V2:
            case Vue_V3:
            case V4:
            default:
                result.put("items", columns + ",t_userfiles.f_table_state state");
                result.put("tableName", "t_userfiles");
                if (tableState != null) {
                    condition = condition + "and t_userfiles.f_table_state = '" + tableState + "'";
                } else {
                    condition = condition + "and t_userfiles.f_table_state IN ('停用','正常')";
                }
                result.put("condition", condition);
                break;
        }
        return result;
    }

    public static JSONObject getMeterInfoCondition(Object meterNumber, String tableState) {
        String columns = String.format("t_userfiles.f_meternumber,t_userfiles.%s userid",
                CompatTools.getOriginalUserFilesId());
        return getMeterInfoCondition(columns, meterNumber, tableState);
    }

    public static JSONObject getMeterInfoCondition(Object meterNumber) {
        return getMeterInfoCondition(meterNumber, null);
    }

    /**
     * 根据表编号获取指定查询列表具信息的Query参数JSON
     *
     * @param columns 查询列 默认：表号(f_meternumber),表档案ID(userid)
     * @param userId  表编号
     * @return 适用于SQL@webmeterGetBaseData的Query参数JSON
     */
    public static JSONObject getMeterInfoCondition2(String columns, Object userId) {
        JSONObject result = new JSONObject();
        result.put("items", columns);
        result.put("tableName", "t_userfiles");
        result.put("condition", "t_userfiles." + CompatTools.getOriginalUserFilesId() + " = '" + userId + "'");
        return result;
    }

    public static JSONObject getMeterInfoCondition2(Object userId) {
        String columns = String.format("t_userfiles.f_meternumber,t_userfiles.%s userid",
                CompatTools.getOriginalUserFilesId());
        return getMeterInfoCondition2(columns, userId);
    }

    /**
     * 获取组织机构字段名称
     */
    public static String getOrganColumnName() {
        switch (WebMeterInfo.getSaleNameEnum()) {
            case Vue_V1:
            case Vue_V2:
                return "f_filialeids";
            case Vue_V3:
            case V4:
                return "f_filialeid";
            default:
                return null;
        }
    }

    /**
     * 根据预定义名称获取通用资源映射名称
     *
     * @param resName  资源预定义名称
     * @param baseType -1：系统细分版本，0：标准系统版本，1：标准系统版本（老命名规则），其他：通用版本
     * @return 通用资源映射名称
     */
    public static String getResName(String resName, Integer baseType) {
        if (baseType == 0) {
            switch (WebMeterInfo.getSaleNameEnum()) {
                case SILVER_LIGHT:
                case SILVER_LIGHT2:
                    return resName + "SL";
                default:
                    return resName + "Vue";
            }
        } else if (baseType == -1) {
            switch (WebMeterInfo.getSaleNameEnum()) {
                case SILVER_LIGHT:
                    return resName + "SL1";
                case SILVER_LIGHT2:
                    return resName + "SL2";
                case Vue_V1:
                    return resName + "V1";
                case Vue_V2:
                    return resName + "V2";
                case Vue_V3:
                    return resName + "V3";
                case V4:
                    return resName + "V4";
                default:
                    return null;
            }
        } else if (baseType == 1) {
            switch (WebMeterInfo.getSaleNameEnum()) {
                case SILVER_LIGHT:
                case SILVER_LIGHT2:
                    return "yinGuang" + resName.substring(0, 1).toUpperCase() + resName.substring(1);
                default:
                    return resName;
            }
        } else {
            return resName;
        }
    }

    public static String getResName(String resName) {
        return getResName(resName, -1);
    }

    public static String getDataSourceResName(String resName) {
        switch (WebMeterInfo.getDataSourceTypeEnum()) {
            case SQLSERVER:
                return resName;
            case ORACLE:
                return resName + "_oracle";
            case MYSQL:
                return resName + "_mysql";
            default:
                return null;
        }
    }

    /**
     * 获取抄表数据表名称
     */
    public static String getHandPlanTableName() {
        String isHandPlan = WebMeterInfo.getString("isHandPlan");
        SaleVersionEnum saleVersionEnum = WebMeterInfo.getSaleNameEnum();
        if ((Objects.equals(isHandPlan, "1") && saleVersionEnum == SaleVersionEnum.Vue_V3) || saleVersionEnum == SaleVersionEnum.V4) {
            return "t_web_handplan";
        } else {
            return "t_handplan";
        }
    }
}
