package com.aote.webmeter.timer;

import com.aote.entity.EntityServer;
import com.aote.sql.SqlServer;
import com.aote.webmeter.enums.DataSourceTypeEnum;
import com.aote.webmeter.tools.CompatTools;
import com.aote.webmeter.tools.WebMeterInfo;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

// 指令同步定时任务
@Component
@Profile("prod")
public class InstructSyncTimer {

    private static final Logger LOG_MANAGER = LogManager.getLogger(InstructSyncTimer.class);

    @Autowired
    EntityServer entityServer;

    @Autowired
    private SqlServer sqlServer;

    // 定时执行数据同步
    @Scheduled(cron = "0 5 9,15,21 * * ?")
    @Transactional
    public void runDataSync() {
        LOG_MANAGER.info("=====开始迁移历史指令=====");
        String instructTableName = CompatTools.getInstructTableName();
        DataSourceTypeEnum dataSourceTypeEnum = WebMeterInfo.getDataSourceTypeEnum();
        String searchSQL = "SELECT * FROM " + instructTableName + " WHERE f_instruct_state IN ('执行成功', '执行失败', '忽略冗余', '无响应') " +
                "OR (f_instruct_state = '响应超时' AND f_inputtor IN ('系统生成','系统档案流程'))";
        if (dataSourceTypeEnum == DataSourceTypeEnum.ORACLE) {
            sqlServer.runSQL("CREATE GLOBAL TEMPORARY TABLE temp_history_instruct ON COMMIT PRESERVE ROWS AS ( " + searchSQL + " )");
            sqlServer.runSQL("INSERT INTO t_instruct_history SELECT * FROM temp_history_instruct");
            sqlServer.runSQL("DELETE FROM " + instructTableName + " WHERE id IN ( SELECT id FROM temp_history_instruct)");
            sqlServer.runSQL("TRUNCATE TABLE temp_history_instruct");
            sqlServer.runSQL("DROP TABLE temp_history_instruct");
        } else if (dataSourceTypeEnum == DataSourceTypeEnum.SQLSERVER) {
            sqlServer.runSQL("SELECT * INTO ##temp_history_instruct FROM ( " + searchSQL + " ) a");
            sqlServer.runSQL("INSERT INTO t_instruct_history SELECT * FROM ##temp_history_instruct");
            sqlServer.runSQL("DELETE FROM " + instructTableName + " WHERE id IN ( SELECT id FROM ##temp_history_instruct)");
            sqlServer.runSQL("DROP TABLE ##temp_history_instruct");
        } else {
            sqlServer.runSQL("CREATE TEMPORARY TABLE temp_history_instruct " + searchSQL);
            sqlServer.runSQL("INSERT INTO t_instruct_history SELECT * FROM temp_history_instruct");
            sqlServer.runSQL("DELETE FROM " + instructTableName + " WHERE id IN ( SELECT id FROM temp_history_instruct)");
            sqlServer.runSQL("DROP TEMPORARY TABLE temp_history_instruct");
        }
        LOG_MANAGER.info("=====历史指令迁移执行完成=====");
    }
}
