/*
 * Decompiled with CFR 0.152.
 */
package com.aote.webmeter.tools.iot.onenet;

import com.af.plugins.HttpAsyncConnectionPoolUtil;
import com.af.plugins.HttpConnectionPoolUtil;
import com.af.plugins.RestTools;
import com.aote.webmeter.enums.OnenetApiEnum;
import com.aote.webmeter.enums.WebmeterPropertiesIOTEnum;
import com.aote.webmeter.tools.WebMeterInfo;
import com.aote.webmeter.tools.iot.onenet.OnenetAuthenticationTools;
import java.io.IOException;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.log4j.Logger;
import org.json.JSONObject;

public class OnenetRestTools {
    private static final Logger LOGGER = Logger.getLogger(OnenetRestTools.class);

    public static JSONObject createDevice(JSONObject params, String imei, String imsi) {
        String msg;
        String path = OnenetApiEnum.DEVICE_URL.getValue();
        JSONObject headers = new JSONObject();
        headers.put("api-key", (Object)WebMeterInfo.getString(WebmeterPropertiesIOTEnum.ONE_NET_APIKEY));
        JSONObject authInfo = new JSONObject();
        authInfo.put(imei, (Object)imsi);
        params.put("auth_info", (Object)authInfo);
        JSONObject result = new JSONObject(HttpConnectionPoolUtil.request((String)path, (String)params.toString(), (String)headers.toString(), (HttpRequestBase)new HttpPost()));
        int errno = result.getInt("errno");
        if (errno == 0) {
            msg = result.getJSONObject("data").getString("device_id");
        } else {
            msg = errno == 6 ? "\u5c1d\u8bd5\u6ce8\u518c\u65f6\u5df2\u7ed1\u5b9a" : "\u6ce8\u518cIOT\u8bbe\u5907\u5931\u8d25\uff1a" + result.getString("error");
            errno = -1;
        }
        return new JSONObject().put("code", errno).put("msg", (Object)msg);
    }

    public static JSONObject createMobileDevice(JSONObject params, String imei, String imsi) {
        String msg;
        String path = OnenetApiEnum.MOBILE_DEVICE_URL.getValue() + "/create";
        params.put("product_id", (Object)WebMeterInfo.getString("onenetAppId"));
        params.put("device_name", (Object)params.getString("title"));
        params.put("imei", (Object)imei);
        params.put("imsi", (Object)imsi);
        JSONObject headers = new JSONObject();
        headers.put("Content-Type", (Object)"application/json");
        headers.put("Authorization", (Object)OnenetAuthenticationTools.getAuthToken());
        JSONObject result = new JSONObject(HttpConnectionPoolUtil.request((String)path, (String)params.toString(), (String)headers.toString(), (HttpRequestBase)new HttpPost()));
        int errno = result.getInt("code");
        if (errno == 0) {
            msg = result.getJSONObject("data").getString("sec_key");
        } else {
            msg = errno == 10406 ? "\u65b0\u589e\u8bbe\u5907\u5931\u8d25\uff1a\u8bbe\u5907\u5df2\u5b58\u5728" : "\u6ce8\u518cIOT\u8bbe\u5907\u5931\u8d25\uff1a" + result.getString("msg");
            errno = -1;
        }
        return new JSONObject().put("code", errno).put("msg", (Object)msg);
    }

    public static JSONObject getDevice(String deviceId) {
        String path = OnenetApiEnum.DEVICE_URL.getValue() + "/" + deviceId;
        JSONObject headers = new JSONObject();
        headers.put("api-key", (Object)WebMeterInfo.getString(WebmeterPropertiesIOTEnum.ONE_NET_APIKEY));
        return new JSONObject(RestTools.get((String)path, (JSONObject)headers));
    }

    public static JSONObject deleteDevice(String deviceId) {
        String msg;
        String path = OnenetApiEnum.DEVICE_URL.getValue() + "/" + deviceId;
        JSONObject headers = new JSONObject();
        headers.put("api-key", (Object)WebMeterInfo.getString(WebmeterPropertiesIOTEnum.ONE_NET_APIKEY));
        JSONObject result = new JSONObject(RestTools.delete((String)path, null, (JSONObject)headers));
        int errno = result.getInt("errno");
        if (errno == 0) {
            msg = "\u6210\u529f";
        } else if (errno == 3) {
            errno = 0;
            msg = "\u5c1d\u8bd5\u5220\u9664\u65f6\u5df2\u4e0d\u5b58\u5728";
        } else {
            errno = -1;
            msg = "\u5220\u9664IOT\u8bbe\u5907\u5931\u8d25\uff1a" + result.getString("error");
        }
        return new JSONObject().put("code", errno).put("msg", (Object)msg);
    }

    public static JSONObject deleteMobileDevice(JSONObject params) throws IOException {
        String msg;
        String path = OnenetApiEnum.MOBILE_DEVICE_URL.getValue() + "/delete";
        params.put("product_id", (Object)WebMeterInfo.getString("onenetAppId"));
        params.put("device_name", (Object)params.getString("meternumber"));
        JSONObject headers = new JSONObject();
        headers.put("Content-Type", (Object)"application/json");
        headers.put("Authorization", (Object)OnenetAuthenticationTools.getAuthToken());
        JSONObject result = new JSONObject(HttpConnectionPoolUtil.request((String)path, (String)params.toString(), (String)headers.toString(), (HttpRequestBase)new HttpPost()));
        int errno = result.getInt("code");
        if (errno == 0) {
            msg = "\u6210\u529f";
        } else if (errno == 10410) {
            errno = 0;
            msg = "\u5c1d\u8bd5\u5220\u9664\u65f6\u5df2\u4e0d\u5b58\u5728";
        } else {
            errno = -1;
            msg = "\u5220\u9664IOT\u8bbe\u5907\u5931\u8d25\uff1a" + result.getString("msg");
        }
        return new JSONObject().put("code", errno).put("msg", (Object)msg);
    }

    public static JSONObject readDeviceRes(String imei, String timeout) {
        JSONObject params = new JSONObject();
        params.put("imei", (Object)imei);
        params.put("obj_id", (Object)WebMeterInfo.getString(WebmeterPropertiesIOTEnum.ONE_NET_OBJECT_ID));
        params.put("obj_inst_id", (Object)WebMeterInfo.getString(WebmeterPropertiesIOTEnum.ONE_NET_OBJECT_INST_ID));
        params.put("res_id", (Object)WebMeterInfo.getString(WebmeterPropertiesIOTEnum.ONE_NET_RES_ID));
        params.put("timeout", (Object)(timeout == null ? "25" : timeout));
        String path = RestTools.formatURL((String)OnenetApiEnum.RESOURCE_URL.getValue(), (JSONObject)params);
        JSONObject headers = new JSONObject();
        headers.put("api-key", (Object)WebMeterInfo.getString(WebmeterPropertiesIOTEnum.ONE_NET_APIKEY));
        return new JSONObject(RestTools.get((String)path, (JSONObject)headers));
    }

    public static JSONObject writeDeviceRes(String imei, String mode, String timeout, JSONObject content) {
        JSONObject params = new JSONObject();
        params.put("imei", (Object)imei);
        params.put("obj_id", (Object)WebMeterInfo.getString(WebmeterPropertiesIOTEnum.ONE_NET_OBJECT_ID));
        params.put("obj_inst_id", (Object)WebMeterInfo.getString(WebmeterPropertiesIOTEnum.ONE_NET_OBJECT_INST_ID));
        params.put("mode", mode == null ? Integer.valueOf(1) : mode);
        params.put("timeout", (Object)(timeout == null ? "25" : timeout));
        String path = RestTools.formatURL((String)OnenetApiEnum.RESOURCE_URL.getValue(), (JSONObject)params);
        JSONObject headers = new JSONObject();
        headers.put("api-key", (Object)WebMeterInfo.getString(WebmeterPropertiesIOTEnum.ONE_NET_APIKEY));
        LOGGER.debug((Object)("\u8bf7\u6c42\u7684\u5730\u5740\uff1a" + path));
        LOGGER.debug((Object)("\u8bf7\u6c42\u5934\uff1a" + headers));
        LOGGER.debug((Object)("\u8bf7\u6c42\u4f53\uff1a" + content));
        HttpAsyncConnectionPoolUtil.request((String)path, (String)content.toString(), (String)headers.toString(), (HttpRequestBase)new HttpPost());
        return new JSONObject().put("errno", 0);
    }

    public static JSONObject sendCommand(String imei, String timeout, JSONObject content) {
        JSONObject params = new JSONObject();
        params.put("imei", (Object)imei);
        params.put("obj_id", (Object)WebMeterInfo.getString(WebmeterPropertiesIOTEnum.ONE_NET_OBJECT_ID));
        params.put("obj_inst_id", (Object)WebMeterInfo.getString(WebmeterPropertiesIOTEnum.ONE_NET_OBJECT_INST_ID));
        params.put("res_id", (Object)WebMeterInfo.getString(WebmeterPropertiesIOTEnum.ONE_NET_RES_ID));
        params.put("timeout", (Object)(timeout == null ? "25" : timeout));
        String path = RestTools.formatURL((String)OnenetApiEnum.COMMAND_URL.getValue(), (JSONObject)params);
        JSONObject headers = new JSONObject();
        headers.put("api-key", (Object)WebMeterInfo.getString(WebmeterPropertiesIOTEnum.ONE_NET_APIKEY));
        LOGGER.debug((Object)("\u8bf7\u6c42\u7684\u5730\u5740\uff1a" + path));
        LOGGER.debug((Object)("\u8bf7\u6c42\u5934\uff1a" + headers));
        LOGGER.debug((Object)("\u8bf7\u6c42\u4f53\uff1a" + content));
        HttpAsyncConnectionPoolUtil.request((String)path, (String)content.toString(), (String)headers.toString(), (HttpRequestBase)new HttpPost());
        return new JSONObject().put("errno", 0);
    }

    public static JSONObject sendNewCommand(String imei, String timeout, JSONObject content) {
        JSONObject params = new JSONObject();
        params.put("imei", (Object)imei);
        params.put("obj_id", (Object)WebMeterInfo.getString(WebmeterPropertiesIOTEnum.ONE_NET_OBJECT_ID));
        params.put("obj_inst_id", (Object)WebMeterInfo.getString(WebmeterPropertiesIOTEnum.ONE_NET_OBJECT_INST_ID));
        params.put("res_id", (Object)WebMeterInfo.getString(WebmeterPropertiesIOTEnum.ONE_NET_RES_ID));
        params.put("timeout", (Object)(timeout == null ? "25" : timeout));
        String path = RestTools.formatURL((String)OnenetApiEnum.COMMAND_URL.getValue(), (JSONObject)params);
        JSONObject headers = new JSONObject();
        headers.put("Authorization", (Object)OnenetAuthenticationTools.getAuthToken());
        LOGGER.debug((Object)("\u8bf7\u6c42\u7684\u5730\u5740\uff1a" + path));
        LOGGER.debug((Object)("\u8bf7\u6c42\u5934\uff1a" + headers));
        LOGGER.debug((Object)("\u8bf7\u6c42\u4f53\uff1a" + content));
        HttpAsyncConnectionPoolUtil.request((String)path, (String)content.toString(), (String)headers.toString(), (HttpRequestBase)new HttpPost());
        return new JSONObject().put("errno", 0);
    }

    public static JSONObject subscribe(JSONObject params) {
        String path = RestTools.formatURL((String)OnenetApiEnum.SUBSCRIPTIONS_URL.getValue(), (JSONObject)params);
        JSONObject headers = new JSONObject();
        headers.put("api-key", (Object)WebMeterInfo.getString(WebmeterPropertiesIOTEnum.ONE_NET_APIKEY));
        String result = HttpConnectionPoolUtil.request((String)path, null, (String)headers.toString(), (HttpRequestBase)new HttpPost());
        return new JSONObject(result);
    }
}

