/*
 * Decompiled with CFR 0.152.
 */
package com.aote.webmeter.tools.iot.onenet;

import com.aote.redis.RedisUtil;
import com.aote.webmeter.tools.WebMeterInfo;
import com.aote.webmeter.tools.iot.AuthenticationTools;
import java.net.URLEncoder;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.log4j.Logger;
import org.json.JSONObject;

public class OnenetAuthenticationTools {
    private static final Logger LOGGER = Logger.getLogger(AuthenticationTools.class);

    private static JSONObject getAuthInfo() {
        String appId = WebMeterInfo.getString("onenetAppId");
        String secret = WebMeterInfo.getString("onenetAPIKey");
        JSONObject result = new JSONObject();
        result.put("appId", (Object)appId);
        result.put("secret", (Object)secret);
        return result;
    }

    public static String getAuthToken(boolean force) {
        JSONObject authInfo = OnenetAuthenticationTools.getAuthInfo();
        String appId = authInfo.getString("appId");
        String secret = authInfo.getString("secret");
        String token = OnenetAuthenticationTools.getToken(appId, force);
        if (token != null) {
            return token;
        }
        return OnenetAuthenticationTools.getWebAuthToken(appId, secret, force);
    }

    public static String getAuthToken() {
        return OnenetAuthenticationTools.getAuthToken(false);
    }

    private static String requestGetToken(String appId, String secret) throws Exception {
        RedisUtil redisUtil = RedisUtil.getInstance();
        LOGGER.info((Object)(appId + ":\u8fdb\u884c\u9274\u6743\u64cd\u4f5c"));
        String result = OnenetAuthenticationTools.getToken();
        LOGGER.info((Object)("\u5f97\u5230\u7684\u9274\u6743\u7ed3\u679c:" + result));
        String newRefreshToken = result;
        redisUtil.set(appId + "_token", (Object)newRefreshToken, 86340L);
        return newRefreshToken;
    }

    private static String getToken(String appId, boolean force) {
        if (force) {
            return null;
        }
        RedisUtil redisUtil = RedisUtil.getInstance();
        Object token = redisUtil.get(appId + "_token");
        if (token != null) {
            LOGGER.info((Object)(appId + ":\u83b7\u53d6\u73b0\u6709token"));
            return String.valueOf(token);
        }
        return null;
    }

    public static synchronized String getWebAuthToken(String appId, String secret, boolean force) {
        RedisUtil redisUtil = RedisUtil.getInstance();
        String[] newAccessToken = new String[1];
        redisUtil.lock(appId, () -> {
            String token = OnenetAuthenticationTools.getToken(appId, force);
            if (force) {
                LOGGER.info((Object)(appId + ":\u8fdb\u884c\u5f3a\u5236\u5237\u65b0\u9274\u6743\u64cd\u4f5c"));
            }
            if (token == null) {
                try {
                    newAccessToken[0] = OnenetAuthenticationTools.requestGetToken(appId, secret);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                newAccessToken[0] = token;
            }
        });
        return newAccessToken[0];
    }

    public static String assembleToken(String version, String resourceName, String expirationTime, String signatureMethod, String accessKey) throws Exception {
        StringBuilder sb = new StringBuilder();
        String res = URLEncoder.encode(resourceName, "UTF-8");
        String sig = URLEncoder.encode(OnenetAuthenticationTools.generatorSignature(version, resourceName, expirationTime, accessKey, signatureMethod), "UTF-8");
        sb.append("version=").append(version).append("&res=").append(res).append("&et=").append(expirationTime).append("&method=").append(signatureMethod).append("&sign=").append(sig);
        return sb.toString();
    }

    public static String generatorSignature(String version, String resourceName, String expirationTime, String accessKey, String signatureMethod) throws NoSuchAlgorithmException, InvalidKeyException {
        String encryptText = expirationTime + "\n" + signatureMethod + "\n" + resourceName + "\n" + version;
        byte[] bytes = OnenetAuthenticationTools.HmacEncrypt(encryptText, accessKey, signatureMethod);
        String signature = Base64.getEncoder().encodeToString(bytes);
        return signature;
    }

    public static byte[] HmacEncrypt(String data, String key, String signatureMethod) throws NoSuchAlgorithmException, InvalidKeyException {
        SecretKeySpec signinKey = null;
        signinKey = new SecretKeySpec(Base64.getDecoder().decode(key), "Hmac" + signatureMethod.toUpperCase());
        Mac mac = null;
        mac = Mac.getInstance("Hmac" + signatureMethod.toUpperCase());
        mac.init(signinKey);
        return mac.doFinal(data.getBytes());
    }

    public static String getToken() throws Exception {
        String version = "2022-05-01";
        String resourceName = "products/" + WebMeterInfo.getString("onenetAppId");
        String expirationTime = System.currentTimeMillis() / 1000L + 86400L + "";
        String signatureMethod = SignatureMethod.SHA1.name().toLowerCase();
        String accessKey = WebMeterInfo.getString("onenetAPIKey");
        return OnenetAuthenticationTools.assembleToken(version, resourceName, expirationTime, signatureMethod, accessKey);
    }

    public static void main(String[] args) throws Exception {
        String version = "2022-05-01";
        String resourceName = "products/9uB0W1UFV1";
        String expirationTime = System.currentTimeMillis() / 1000L + 86400L + "";
        String signatureMethod = SignatureMethod.SHA1.name().toLowerCase();
        String accessKey = "cwHn+9vNE5vvB9Ez9+NVUZ1/O6/BO+HFa8PFmeOd2yc=";
        System.out.println(OnenetAuthenticationTools.assembleToken(version, resourceName, expirationTime, signatureMethod, accessKey));
    }

    public static enum SignatureMethod {
        SHA1,
        MD5,
        SHA256;

    }
}

