-- 公共SQL：生成调价指令（适用V3，用于直接使用气价明细调价的情况）
-- 必选参数
-- f_meter_brand：表具品牌别名
-- setPriceSync：调价记录同步状态字段

SELECT
    -- 业务记录ID
    setinfo.id,
    -- 表档案ID
    setinfo.userid,
    -- 表档案编号
    setinfo.f_user_id,
    -- 表号
    setinfo.f_meternumber,
    -- 卡号
    setinfo.f_card_id,
    -- 气价ID
    setinfo.stairid,
    -- 旧气价ID
    setinfo.oldstairid,
    -- 阶梯开始时间
    setinfo.start_date,
    -- 价格生效时间
    setinfo.f_perform_date,
    -- 阶梯周期（月）
    setinfo.f_stairmonths,
    -- 是否采暖气价
    setinfo.f_isheat,
    -- 调价类型
    setinfo.type,
    -- 价格版本
    setinfo.priceversion,
    -- 结算类型（按金额，按气量）
    setinfo.f_collection_type,
    -- 气表型号
    setinfo.f_meter_style,
    setinfo.f_newprice_json,
    --价格名称
    setinfo.f_price_name
FROM (
         SELECT p.id                                           id,
                u.f_userfiles_id                               userid,
                u.f_user_id,
                u.f_meternumber,
                NVL(u.f_card_id, u.f_meternumber)              f_card_id,
                s.id                                           stairId,
                p.f_oldprice_id                                oldstairid,
                s.f_version + u.f_price_version                priceversion,
                NVL(s.f_stair_start_date, s.f_perform_date)    start_date,
                p.f_perform_date                               f_perform_date,
                NVL(s.f_stairmonths, 1)                        f_stairmonths,
                m.f_meter_style                                f_meter_style,
                p.f_newprice_json,
                s.f_isheat,
                g.f_collection_type,
                s.f_price_name,
                case p.f_change_type
                    when '批量' then '批量调价'
                    when '单户' then '单户调价'
                    else f_change_type
                    end                                        type
         FROM t_pricechange p
                  INNER JOIN t_userfiles u ON u.f_userinfo_id = p.f_userinfo_id
                  LEFT JOIN t_gasbrand g ON u.f_gasbrand_id = g.id
                  LEFT JOIN t_gasmodel m ON u.f_gasmodel_id = m.id
                  LEFT JOIN t_stairprice s ON s.id = p.f_newprice_id and s.f_filialeid like concat(concat('%',u.f_orgid),'%')
         WHERE s.f_state = '有效'
           AND sysdate <= s.f_end_date
           AND (p.${setPriceSync} = '未同步' or p.${setPriceSync} is null)
           AND u.f_sendsuccess = '成功'
           AND u.f_table_state = '正常'
           AND g.f_alias = '{f_meter_brand}'
           AND g.f_calculation = '表端结算'
     ) setinfo
